/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.app.service;

import com.bxm.app.dal.mapper.ext.DeductBalanceRecordMapperExt;
import com.bxm.app.dal.model.DeductBalanceRecord;
import com.bxm.util.CommonValidate;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeductBalanceRecordService {
    @Autowired
    private DeductBalanceRecordMapperExt deductBalanceRecordMapperExt;

    public boolean add(DeductBalanceRecord deductBalanceRecord) throws ValidateException, Exception {
        return this.deductBalanceRecordMapperExt.insertSelective(deductBalanceRecord) == 1;
    }

    public boolean update(DeductBalanceRecord app) throws ValidateException, Exception {
        CommonValidate.me.checkParam((Object)app);
        CommonValidate.me.checkParam((Object)app.getId());
        return this.deductBalanceRecordMapperExt.updateByPrimaryKeySelective(app) == 1;
    }

    public DeductBalanceRecord getById(Long id) throws ValidateException, Exception {
        CommonValidate.me.checkParam((Object)id);
        return this.deductBalanceRecordMapperExt.selectByPrimaryKey(id);
    }

    public PageInfo<DeductBalanceRecord> getList(Integer pageIndex, Integer pageSize, String orderParam, String orderType, Date startTime, Date endTime, Integer userId, String oid, String appOid, Integer appId, String appUid, Byte status) throws ValidateException, Exception {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (StringUtil.isNotBlank((CharSequence)oid)) {
            paramsMap.put("oid", oid.trim());
        }
        if (StringUtil.isNotBlank((CharSequence)appOid)) {
            paramsMap.put("appOid", appOid.trim());
        }
        paramsMap.put("startTime", startTime);
        paramsMap.put("endTime", endTime);
        paramsMap.put("orderParam", orderParam);
        paramsMap.put("orderType", orderType);
        paramsMap.put("userId", userId);
        paramsMap.put("appId", appId);
        paramsMap.put("appUid", appUid);
        paramsMap.put("status", status);
        if (pageSize > 50) {
            pageSize = 50;
        }
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        return new PageInfo(this.deductBalanceRecordMapperExt.getList(paramsMap));
    }

    public List<DeductBalanceRecord> getListByIds(String ids) {
        ArrayList<Long> idList = new ArrayList<Long>();
        HashMap<String, ArrayList<Long>> paramsMap = new HashMap<String, ArrayList<Long>>();
        if (StringUtil.isNotBlank((CharSequence)ids)) {
            for (String id : ids.split(",")) {
                idList.add(Long.valueOf(id));
            }
            if (idList.size() == 0) {
                return null;
            }
            paramsMap.put("ids", idList);
        }
        return this.deductBalanceRecordMapperExt.getListByIds(paramsMap);
    }

    public DeductBalanceRecord getByOid(String oid) {
        CommonValidate.me.checkParam((Object)oid);
        return this.deductBalanceRecordMapperExt.getByOid(oid);
    }
}

