/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.app.service;

import com.bxm.app.dal.mapper.ext.ProviderAppFacadeMapperExt;
import com.bxm.app.model.dto.ProviderAppAdDto;
import com.bxm.app.model.ro.ProviderAppAdRo;
import com.bxm.util.CommonValidate;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ValidateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProviderAppFacadeService {
    @Autowired
    private ProviderAppFacadeMapperExt providerAppFacadeMapperExt;

    public boolean updateProviderAppAdInfo(ProviderAppAdDto providerAppAdDto) throws ValidateException, Exception {
        CommonValidate.me.checkParam((Object)providerAppAdDto.getId());
        return this.providerAppFacadeMapperExt.updateProviderAppAdInfo(providerAppAdDto) == 1;
    }

    public boolean updateProviderAppByAppKey(ProviderAppAdDto providerAppAdDto) throws ValidateException, Exception {
        CommonValidate.me.checkParam((Object)providerAppAdDto.getAppKey());
        return this.providerAppFacadeMapperExt.updateProviderAppByAppKey(providerAppAdDto) == 1;
    }

    public ProviderAppAdRo getById(Long id) throws ValidateException, Exception {
        CommonValidate.me.checkParam((Object)id);
        return this.providerAppFacadeMapperExt.getById(id);
    }

    public List<ProviderAppAdRo> getList(String keywords) throws ValidateException, Exception {
        if (StringUtil.isNotBlank((CharSequence)keywords)) {
            keywords = keywords.trim();
        }
        return this.providerAppFacadeMapperExt.getList(keywords);
    }

    public List<ProviderAppAdRo> getList(Integer advanceType, String keywords) throws ValidateException, Exception {
        List<String> appkeys = null;
        if (StringUtils.isNotBlank((CharSequence)keywords)) {
            String[] keys = keywords.split(",");
            appkeys = Arrays.asList(keys);
        }
        return this.providerAppFacadeMapperExt.getListByAdvanceType(advanceType, appkeys);
    }

    public List<String> getProviderByState() {
        if (CollectionUtils.isNotEmpty((Collection)this.providerAppFacadeMapperExt.getProviderByState())) {
            return this.providerAppFacadeMapperExt.getProviderByState();
        }
        return new ArrayList<String>();
    }

    public List<String> getAppkeyByEmail(String email) {
        List rs = this.providerAppFacadeMapperExt.getAppkeyByEmail(email);
        return rs;
    }

    public List<ProviderAppAdRo> getListByAppNameOrAppkey(String keywords) {
        return this.providerAppFacadeMapperExt.getListByAppNameOrAppkey(keywords);
    }
}

