/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.app.service;

import com.bxm.app.dal.mapper.AppRechargeMapper;
import com.bxm.app.dal.mapper.ext.ProviderAppMapperExt;
import com.bxm.app.dal.mapper.ext.ProviderMapperExt;
import com.bxm.app.dal.model.AppRecharge;
import com.bxm.app.dal.model.DeductBalanceRecord;
import com.bxm.app.dal.model.Provider;
import com.bxm.app.dal.model.ProviderApp;
import com.bxm.app.model.enums.PayChannelEnum;
import com.bxm.app.service.DeductBalanceRecordService;
import com.bxm.util.CommonValidate;
import com.bxm.util.StringUtil;
import com.bxm.util.UuidUtil;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProviderAppService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ProviderAppMapperExt providerAppMapperExt;
    @Autowired
    private ProviderMapperExt providerMapperExt;
    @Autowired
    private DeductBalanceRecordService deductBalanceRecordService;
    @Autowired
    private AppRechargeMapper appRechargeMapper;

    public Long add(ProviderApp providerApp) throws ValidateException, Exception {
        providerApp.setAppSecret(UuidUtil.getUuidByJdk((boolean)true));
        providerApp.setAppKey(UuidUtil.getUuidByJdk((boolean)true));
        if (this.providerAppMapperExt.insertSelective(providerApp) == 1) {
            return providerApp.getId();
        }
        return null;
    }

    public boolean update(ProviderApp providerApp) throws ValidateException, Exception {
        CommonValidate.me.checkParam((Object)providerApp);
        CommonValidate.me.checkParam((Object)providerApp.getId());
        providerApp.setGmtModify(new Date());
        return this.providerAppMapperExt.updateByPrimaryKeySelective(providerApp) == 1;
    }

    public ProviderApp getById(Long id) throws ValidateException, Exception {
        CommonValidate.me.checkParam((Object)id);
        return this.providerAppMapperExt.selectByPrimaryKey(id);
    }

    public PageInfo<ProviderApp> getList(Integer pageIndex, Integer pageSize, String orderParam, String orderType, String keywords, Date startTime, Date endTime) throws ValidateException, Exception {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (StringUtil.isNotBlank((CharSequence)keywords)) {
            paramsMap.put("keywords", keywords.trim());
        }
        paramsMap.put("startTime", startTime);
        paramsMap.put("endTime", endTime);
        paramsMap.put("orderParam", orderParam);
        paramsMap.put("orderType", orderType);
        if (pageSize > 50) {
            pageSize = 50;
        }
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        return new PageInfo(this.providerAppMapperExt.getList(paramsMap));
    }

    public List<ProviderApp> getListByIds(String ids) {
        ArrayList<Long> idList = new ArrayList<Long>();
        HashMap<String, ArrayList<Long>> paramsMap = new HashMap<String, ArrayList<Long>>();
        if (StringUtil.isNotBlank((CharSequence)ids)) {
            for (String id : ids.split(",")) {
                idList.add(Long.valueOf(id));
            }
            if (idList.size() == 0) {
                return null;
            }
            paramsMap.put("ids", idList);
        }
        return this.providerAppMapperExt.getListByIds(paramsMap);
    }

    public ProviderApp getByAppKey(String appKey) {
        return this.providerAppMapperExt.getByAppKey(appKey);
    }

    public List<Long> getIdsByParams(String keywords, Long appId) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (StringUtil.isNotBlank((CharSequence)keywords)) {
            paramsMap.put("keywords", keywords.trim());
        }
        paramsMap.put("providerIds", this.providerMapperExt.getIdsByParams(paramsMap));
        paramsMap.put("id", appId);
        return this.providerAppMapperExt.getIdsByParams(paramsMap);
    }

    public List<ProviderApp> getList() {
        return this.providerAppMapperExt.getList(null);
    }

    public PageInfo<ProviderApp> getList(Integer pageNum, Integer pageSize, String keyword, String isFrozen) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (StringUtil.isNotEmpty((CharSequence)keyword)) {
            map.put("keywords", keyword);
        }
        if (StringUtil.isNotEmpty((CharSequence)isFrozen)) {
            map.put("isFrozen", isFrozen);
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return new PageInfo(this.providerAppMapperExt.getListByCondition(map));
    }

    @Transactional
    public Boolean deductAppAdvancePayment(Long appId, Long userId, BigDecimal deductAmount, String orderNum, String remark) throws ValidateException, Exception {
        ProviderApp providerApp = this.providerAppMapperExt.selectByPrimaryKey(appId);
        if (providerApp == null) {
            this.log.warn("app\u4e0d\u5b58\u5728,appId:{}", (Object)appId);
            throw new ValidateException("\u9884\u5b58\u6b3e\u4e0d\u8db3");
        }
        Provider provider = this.providerMapperExt.selectByPrimaryKey(providerApp.getProviderId());
        if (provider == null) {
            this.log.warn("app\u4e0d\u5b58\u5728,appId:{}", (Object)appId);
            throw new ValidateException("\u9884\u5b58\u6b3e\u4e0d\u8db3");
        }
        if (provider.getAdvancePayment() == null || provider.getAdvancePayment().compareTo(new BigDecimal(0)) != 1) {
            throw new ValidateException("\u4eca\u65e5\u540d\u989d\u5df2\u6ee1");
        }
        if (deductAmount.compareTo(provider.getAdvancePayment()) == 1) {
            throw new ValidateException("The exchange quota is full today");
        }
        if (providerApp.getBudgetPerDayBalance() != null && providerApp.getBudgetPerDayBalance().compareTo(new BigDecimal(-1)) != 0 && deductAmount.compareTo(providerApp.getBudgetPerDayBalance()) == 1 || providerApp.getBudgetPerMonthBalance() != null && providerApp.getBudgetPerMonthBalance().compareTo(new BigDecimal(-1)) != 0 && deductAmount.compareTo(providerApp.getBudgetPerMonthBalance()) == 1) {
            this.log.warn("app\u4eca\u65e5\u9650\u989d\u5df2\u6ee1,appId:{},\u4eca\u65e5\u9650\u989d\u5269\u4f59\uff1a{},\u672c\u6708\u9650\u989d\u5269\u4f59\uff1a{}", new Object[]{appId, providerApp.getBudgetPerDayBalance(), providerApp.getBudgetPerMonthBalance()});
            throw new ValidateException("\u4eca\u65e5\u9650\u989d\u5df2\u6ee1");
        }
        if (deductAmount != null && deductAmount.compareTo(new BigDecimal(0)) == 1) {
            providerApp.setBudgetPerDayBalance(providerApp.getBudgetPerDayBalance().subtract(deductAmount));
            providerApp.setBudgetPerMonthBalance(providerApp.getBudgetPerMonthBalance().subtract(deductAmount));
            this.providerAppMapperExt.updateByPrimaryKeySelective(providerApp);
            provider.setAdvancePayment(provider.getAdvancePayment().subtract(deductAmount));
            this.deductBalanceRecord(userId, deductAmount, orderNum, remark, providerApp);
            return this.providerMapperExt.updateByPrimaryKeySelective(provider) == 1;
        }
        return false;
    }

    @Transactional
    public Boolean addAppAdvancePayment(Long appId, BigDecimal addAmount, String orderNum, String remark) throws ValidateException, Exception {
        ProviderApp providerApp = this.providerAppMapperExt.selectByPrimaryKey(appId);
        if (providerApp == null) {
            this.log.warn("app\u4e0d\u5b58\u5728,appId:{}", (Object)appId);
            throw new ValidateException("app\u4e0d\u5b58\u5728");
        }
        Provider provider = this.providerMapperExt.selectByPrimaryKey(providerApp.getProviderId());
        if (provider == null) {
            this.log.warn("app\u4e0d\u5b58\u5728,appId:{}", (Object)appId);
            throw new ValidateException("app\u4e0d\u5b58\u5728");
        }
        if (addAmount != null && addAmount.compareTo(new BigDecimal(0)) != 1) {
            this.log.warn("\u9884\u5b58\u6b3e\u8981\u5927\u4e8e0:{}", (Object)addAmount);
            throw new ValidateException("\u9884\u5b58\u6b3e\u8981\u5927\u4e8e0");
        }
        providerApp.setBudgetPerDayBalance(providerApp.getBudgetPerDayBalance().add(addAmount));
        providerApp.setBudgetPerMonthBalance(providerApp.getBudgetPerMonthBalance().add(addAmount));
        this.providerAppMapperExt.updateByPrimaryKeySelective(providerApp);
        provider.setAdvancePayment(provider.getAdvancePayment().add(addAmount));
        this.addAppRechargeRecord(addAmount, orderNum, remark, providerApp, provider);
        return this.providerMapperExt.updateByPrimaryKeySelective(provider) == 1;
    }

    private void addAppRechargeRecord(BigDecimal addAmount, String orderNum, String remark, ProviderApp providerApp, Provider provider) {
        AppRecharge record = new AppRecharge();
        record.setAdvancePaymentBlance(provider.getAdvancePayment());
        record.setAmount(addAmount);
        record.setOrderNum(orderNum);
        record.setProviderId(providerApp.getProviderId());
        record.setRemark(remark);
        record.setState("success");
        record.setPaymentMethod(PayChannelEnum.JI_FEN_PAY.getCode() + "");
        this.appRechargeMapper.insert(record);
    }

    private void deductBalanceRecord(Long userId, BigDecimal deductAmount, String orderNum, String remark, ProviderApp providerApp) throws Exception {
        DeductBalanceRecord deductBalanceRecord = this.deductBalanceRecordService.getByOid(orderNum);
        if (deductBalanceRecord != null) {
            throw new ValidateException("\u6b64\u8ba2\u5355\u652f\u4ed8\u8fc7\uff0c\u8bf7\u52ff\u91cd\u65b0\u652f\u4ed8");
        }
        DeductBalanceRecord deductBalanceRecordInsert = new DeductBalanceRecord();
        deductBalanceRecordInsert.setAppId(providerApp.getId());
        deductBalanceRecordInsert.setOid(orderNum);
        deductBalanceRecordInsert.setAmount(deductAmount);
        deductBalanceRecordInsert.setAppStatus(Byte.valueOf((byte)1));
        deductBalanceRecordInsert.setStatus(Byte.valueOf((byte)1));
        deductBalanceRecordInsert.setUserId(userId);
        deductBalanceRecordInsert.setRemark(remark);
        this.deductBalanceRecordService.add(deductBalanceRecordInsert);
    }
}

