/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.app.service;

import com.bxm.app.dal.mapper.ext.ProviderMapperExt;
import com.bxm.app.dal.model.Provider;
import com.bxm.util.CommonValidate;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProviderService {
    @Autowired
    private ProviderMapperExt providerMapperExt;

    public Long add(Provider provider) throws ValidateException, Exception {
        if (this.providerMapperExt.insertSelective(provider) == 1) {
            return provider.getId();
        }
        return null;
    }

    public boolean update(Provider provider) throws ValidateException, Exception {
        CommonValidate.me.checkParam((Object)provider);
        CommonValidate.me.checkParam((Object)provider.getId());
        provider.setGmtModify(new Date());
        return this.providerMapperExt.updateByPrimaryKeySelective(provider) == 1;
    }

    public Provider getById(Long id) throws ValidateException, Exception {
        CommonValidate.me.checkParam((Object)id);
        return this.providerMapperExt.selectByPrimaryKey(id);
    }

    public PageInfo<Provider> getList(Integer pageIndex, Integer pageSize, String orderParam, String orderType, String keywords, Date startTime, Date endTime, String mobile, String email, String linkman) throws ValidateException, Exception {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (StringUtil.isNotBlank((CharSequence)keywords)) {
            paramsMap.put("keywords", keywords.trim());
        }
        paramsMap.put("startTime", startTime);
        paramsMap.put("endTime", endTime);
        paramsMap.put("mobile", mobile);
        paramsMap.put("email", email);
        paramsMap.put("linkman", linkman);
        paramsMap.put("orderParam", orderParam);
        paramsMap.put("orderType", orderType);
        if (pageSize > 50) {
            pageSize = 50;
        }
        PageHelper.startPage((int)pageIndex, (int)pageSize);
        return new PageInfo(this.providerMapperExt.getList(paramsMap));
    }

    public List<Provider> getListByIds(String ids) {
        ArrayList<Long> idList = new ArrayList<Long>();
        HashMap<String, ArrayList<Long>> paramsMap = new HashMap<String, ArrayList<Long>>();
        if (StringUtil.isNotBlank((CharSequence)ids)) {
            for (String id : ids.split(",")) {
                idList.add(Long.valueOf(id));
            }
            if (idList.size() == 0) {
                return null;
            }
            paramsMap.put("ids", idList);
        }
        return this.providerMapperExt.getListByIds(paramsMap);
    }
}

