/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.app.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.bxm.app.config.DruidProperties;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={DruidProperties.class})
@ConditionalOnClass(value={DruidDataSource.class})
@ConditionalOnProperty(prefix="druid", name={"url"})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
public class DruidAutoConfiguration {
    @Autowired
    private DruidProperties properties;

    @Bean
    @Primary
    @ConfigurationProperties(prefix="datasource.primary")
    public DataSource dataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(this.properties.getUrl());
        dataSource.setUsername(this.properties.getUsername());
        dataSource.setPassword(this.properties.getPassword());
        if (this.properties.getInitialSize() > 0) {
            dataSource.setInitialSize(this.properties.getInitialSize());
        }
        if (this.properties.getMinIdle() > 0) {
            dataSource.setMinIdle(this.properties.getMinIdle());
        }
        if (this.properties.getMaxActive() > 0) {
            dataSource.setMaxActive(this.properties.getMaxActive());
        }
        dataSource.setTestOnBorrow(this.properties.isTestOnBorrow());
        try {
            dataSource.init();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return dataSource;
    }
}

