/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.app.service;

import com.alibaba.fastjson.JSON;
import com.bxm.app.config.RedisClient;
import com.bxm.app.dal.mapper.ext.ProviderAppMapperExt;
import com.bxm.app.dal.mapper.ext.ProviderMapperExt;
import com.bxm.app.dal.model.DeductBalanceRecord;
import com.bxm.app.dal.model.DeductPointRecord;
import com.bxm.app.dal.model.Provider;
import com.bxm.app.dal.model.ProviderApp;
import com.bxm.app.model.dto.AppPointDto;
import com.bxm.app.service.DeductBalanceRecordService;
import com.bxm.app.service.DeductPointRecordService;
import com.bxm.app.service.ProviderAppService;
import com.bxm.util.MD5Util;
import com.bxm.util.OkHttpUtils;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ValidateException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppPointService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ProviderMapperExt providerMapperExt;
    @Autowired
    private DeductPointRecordService deductPointRecordService;
    @Autowired
    private ProviderAppMapperExt providerAppMapperExt;
    @Autowired
    private DeductBalanceRecordService deductBalanceRecordService;
    @Autowired
    private RedisClient redisClient;
    @Autowired
    private ProviderAppService providerAppService;

    public int getUserPoint(String appUid, Long appId) throws ValidateException, Exception {
        int point = 0;
        ProviderApp providerApp = (ProviderApp)this.redisClient.getObject("app:" + appId);
        if (providerApp == null) {
            providerApp = this.providerAppService.getById(appId);
            if (providerApp == null) {
                return point;
            }
            this.redisClient.setObject("app:" + appId, 7200, providerApp);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("timestamp", System.currentTimeMillis());
        params.put("appKey", providerApp.getAppKey());
        params.put("appUid", appUid);
        String sign = MD5Util.sign(params, (String)providerApp.getAppSecret());
        params.put("sign", sign);
        if (StringUtil.isBlank((CharSequence)providerApp.getAppPointApi())) {
            this.log.warn("\u67e5\u8be2\u79ef\u5206\u63a5\u53e3\u6ca1\u6709\u914d\u7f6e,appId:{}", (Object)appId);
            return point;
        }
        String responseStr = "";
        try {
            responseStr = OkHttpUtils.get((String)providerApp.getAppPointApi(), params);
            if (StringUtil.isNotBlank((CharSequence)responseStr)) {
                AppPointDto appPointDto = (AppPointDto)JSON.parseObject((String)responseStr, AppPointDto.class);
                if (appPointDto != null && appPointDto.getStatus().equals("ok") && appPointDto.getPoint() != null) {
                    return appPointDto.getPoint();
                }
                if (appPointDto.getErrorMessage() != null) {
                    this.log.warn("\u67e5\u8be2\u79ef\u5206\u63a5\u53e3\u51fa\u9519,appId:{},msg:{}", (Object)appId, (Object)URLDecoder.decode(appPointDto.getErrorMessage(), "UTF-8"));
                    throw new ValidateException(URLDecoder.decode(appPointDto.getErrorMessage(), "UTF-8"));
                }
                throw new ValidateException("\u63a5\u53e3\u51fa\u9519");
            }
        }
        catch (Exception e) {
            this.log.error("\u8c03\u7528\u5f00\u53d1\u8005\u67e5\u8be2\u79ef\u5206\u63a5\u53e3\u51fa\u9519:responseStr--------{}", (Object)responseStr);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            this.log.error("---------> system huge error:{}", (Object)sw.toString());
            throw new ValidateException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return 0;
    }

    @Transactional
    public Boolean deductUserPoint(Long userId, String appUid, Long appId, String orderNum, BigDecimal deductAmount, Integer point) throws ValidateException, Exception {
        if (point == null || point <= 0) {
            throw new ValidateException("\u6263\u9664\u79ef\u5206\u5fc5\u987b\u5927\u4e8e0");
        }
        ProviderApp providerApp = (ProviderApp)this.redisClient.getObject("app:" + appId);
        if (providerApp == null) {
            providerApp = this.providerAppService.getById(appId);
            if (providerApp == null) {
                this.log.warn("app\u4e0d\u5b58\u5728,appId:{}", (Object)appId);
                throw new ValidateException("\u79ef\u5206\u4e0d\u8db3");
            }
            this.redisClient.setObject("app:" + appId, 7200, providerApp);
        }
        if (StringUtil.isBlank((CharSequence)providerApp.getDeductAppPointApi())) {
            this.log.warn("\u6263\u9664\u79ef\u5206\u63a5\u53e3\u6ca1\u6709\u914d\u7f6e,appId:{}", (Object)appId);
            throw new ValidateException("\u79ef\u5206\u4e0d\u8db3");
        }
        Provider provider = this.providerMapperExt.selectByPrimaryKey(providerApp.getProviderId());
        this.checkParam(appUid, appId, orderNum, deductAmount, point, providerApp, provider);
        return this.deductPoint(userId, appUid, appId, orderNum, deductAmount, point, providerApp, provider);
    }

    private void checkParam(String appUid, Long appId, String orderNum, BigDecimal deductAmount, Integer point, ProviderApp providerApp, Provider provider) throws Exception {
        int balancePoint;
        if (provider == null) {
            this.log.warn("app\u4e0d\u5b58\u5728,appId:{}", (Object)appId);
            throw new ValidateException("\u79ef\u5206\u4e0d\u8db3");
        }
        if (deductAmount != null && deductAmount.compareTo(new BigDecimal(0)) != 0) {
            if (provider.getAdvancePayment() == null || provider.getAdvancePayment().compareTo(new BigDecimal(0)) != 1) {
                this.log.warn("app\u9884\u5b58\u6b3e\u4e0d\u8db3,appId:{},\u9884\u5b58\u6b3e\u5269\u4f59\uff1a{}", (Object)appId, (Object)provider.getAdvancePayment());
                throw new ValidateException("\u4eca\u65e5\u540d\u989d\u5df2\u6ee1");
            }
            if (deductAmount == null || deductAmount.compareTo(provider.getAdvancePayment()) == 1) {
                this.log.warn("app\u9884\u5b58\u6b3e\u4e0d\u8db3,appId:{},\u9884\u5b58\u6b3e\u5269\u4f59\uff1a{}", (Object)appId, (Object)provider.getAdvancePayment());
                throw new ValidateException("\u4eca\u65e5\u540d\u989d\u5df2\u6ee1");
            }
            DeductPointRecord deductPointRecordTmp = this.deductPointRecordService.getByOid(orderNum);
            if (deductPointRecordTmp != null && deductPointRecordTmp.getStatus() == 1) {
                this.log.warn("app\u8ba2\u5355\u5df2\u652f\u4ed8,appId:{},\u8ba2\u5355\u53f7\uff1a{}", (Object)appId, (Object)orderNum);
                throw new ValidateException("\u8ba2\u5355\u5df2\u652f\u4ed8");
            }
            if (providerApp.getBudgetPerDayBalance() != null && providerApp.getBudgetPerDayBalance().compareTo(new BigDecimal(-1)) != 0 && deductAmount.compareTo(providerApp.getBudgetPerDayBalance()) == 1 || providerApp.getBudgetPerMonthBalance() != null && providerApp.getBudgetPerMonthBalance().compareTo(new BigDecimal(-1)) != 0 && deductAmount.compareTo(providerApp.getBudgetPerMonthBalance()) == 1) {
                this.log.warn("app\u4eca\u65e5\u9650\u989d\u5df2\u6ee1,appId:{},\u4eca\u65e5\u9650\u989d\u5269\u4f59\uff1a{},\u672c\u6708\u9650\u989d\u5269\u4f59\uff1a{}", new Object[]{appId, providerApp.getBudgetPerDayBalance(), providerApp.getBudgetPerMonthBalance()});
                throw new ValidateException("\u4eca\u65e5\u9650\u989d\u5df2\u6ee1");
            }
        }
        if ((balancePoint = this.getUserPoint(appUid, appId)) < point) {
            this.log.warn("app\u7528\u6237id\u4e3a:{}\u7684\u79ef\u5206\u4e0d\u8db3,appId:{},\u5269\u4f59\u79ef\u5206\uff1a{},\u672c\u6b21\u6263\u9664\u79ef\u5206\uff1a{}", new Object[]{appUid, appId, balancePoint, point});
            throw new ValidateException("\u79ef\u5206\u4e0d\u8db3");
        }
        DeductBalanceRecord deductBalanceRecord = this.deductBalanceRecordService.getByOid(orderNum);
        if (deductBalanceRecord != null) {
            throw new ValidateException("\u6b64\u8ba2\u5355\u652f\u4ed8\u8fc7\uff0c\u8bf7\u52ff\u91cd\u65b0\u652f\u4ed8");
        }
    }

    private Boolean deductPoint(Long userId, String appUid, Long appId, String orderNum, BigDecimal deductAmount, Integer point, ProviderApp providerApp, Provider provider) throws Exception, IOException, UnsupportedEncodingException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("timestamp", System.currentTimeMillis());
        params.put("appKey", providerApp.getAppKey());
        params.put("point", point);
        params.put("appUid", appUid);
        params.put("description", "\u6263\u9664\u79ef\u5206\u901a\u77e5");
        params.put("orderNum", orderNum);
        String sign = MD5Util.sign(params, (String)providerApp.getAppSecret());
        params.put("sign", sign);
        String responseStr = "";
        try {
            responseStr = OkHttpUtils.post((String)providerApp.getDeductAppPointApi(), params);
        }
        catch (Exception e) {
            this.log.error("\u8c03\u7528\u5f00\u53d1\u8005\u6263\u9664\u79ef\u5206\u63a5\u53e3\u51fa\u9519:responseStr--------{}", (Object)responseStr);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            this.log.error("---------> system huge error:{}", (Object)sw.toString());
            throw new ValidateException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        if (StringUtil.isBlank((CharSequence)responseStr)) {
            throw new ValidateException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        AppPointDto appPointDto = (AppPointDto)JSON.parseObject((String)responseStr, AppPointDto.class);
        if (appPointDto != null && appPointDto.getStatus().equals("ok")) {
            return this.deductSuccess(userId, appUid, appId, orderNum, deductAmount, point, providerApp, provider, appPointDto);
        }
        this.deductFail(userId, appUid, appId, orderNum, deductAmount, point, appPointDto);
        return false;
    }

    private Boolean deductSuccess(Long userId, String appUid, Long appId, String orderNum, BigDecimal deductAmount, Integer point, ProviderApp providerApp, Provider provider, AppPointDto appPointDto) throws Exception {
        DeductPointRecord deductPointRecord = new DeductPointRecord();
        deductPointRecord.setAppId(appId);
        deductPointRecord.setAppOid(appPointDto.getAppOrderNum());
        deductPointRecord.setPoint(point);
        deductPointRecord.setOid(orderNum);
        deductPointRecord.setAppUid(appUid);
        deductPointRecord.setAmount(deductAmount);
        deductPointRecord.setAppStatus(Byte.valueOf((byte)1));
        deductPointRecord.setUserId(userId);
        boolean isDeductSuccess = true;
        if (deductAmount != null && deductAmount.compareTo(new BigDecimal(0)) == 1) {
            providerApp.setBudgetPerDayBalance(providerApp.getBudgetPerDayBalance().subtract(deductAmount));
            providerApp.setBudgetPerMonthBalance(providerApp.getBudgetPerMonthBalance().subtract(deductAmount));
            this.providerAppMapperExt.updateByPrimaryKeySelective(providerApp);
            isDeductSuccess = this.providerMapperExt.deductAdvancePayment(provider.getId(), deductAmount) == 1;
            DeductBalanceRecord deductBalanceRecordInsert = new DeductBalanceRecord();
            BeanUtils.copyProperties((Object)deductPointRecord, (Object)deductBalanceRecordInsert);
            this.deductBalanceRecordService.add(deductBalanceRecordInsert);
        }
        if (isDeductSuccess) {
            deductPointRecord.setStatus(Byte.valueOf((byte)1));
            this.deductPointRecordService.add(deductPointRecord);
            this.deductUserPointConfirm(appUid, providerApp, deductPointRecord, orderNum, "ok");
            return true;
        }
        deductPointRecord.setStatus(Byte.valueOf((byte)0));
        deductPointRecord.setRemark("\u6263\u9664\u9884\u5b58\u6b3e\u5931\u8d25");
        this.deductPointRecordService.add(deductPointRecord);
        this.deductUserPointConfirm(appUid, providerApp, deductPointRecord, orderNum, "fail");
        return false;
    }

    private void deductFail(Long userId, String appUid, Long appId, String orderNum, BigDecimal deductAmount, Integer point, AppPointDto appPointDto) throws UnsupportedEncodingException, Exception {
        DeductPointRecord deductPointRecord = new DeductPointRecord();
        deductPointRecord.setAppId(appId);
        deductPointRecord.setAppOid(appPointDto.getAppOrderNum());
        deductPointRecord.setPoint(point);
        deductPointRecord.setAppUid(appUid);
        deductPointRecord.setOid(orderNum);
        deductPointRecord.setAmount(deductAmount);
        deductPointRecord.setAppStatus(Byte.valueOf((byte)0));
        deductPointRecord.setStatus(Byte.valueOf((byte)0));
        deductPointRecord.setUserId(userId);
        if (StringUtil.isBlank((CharSequence)appPointDto.getErrorMessage())) {
            deductPointRecord.setRemark("\u6263\u9664\u5f00\u53d1\u8005\u79ef\u5206\u5931\u8d25");
            this.log.warn("\u7528\u6237ID:{}\uff0cappUid\uff1a{}\uff0c\u6263\u9664\u79ef\u5206\u6570\u91cf:{}\uff0c\u6263\u9664\u9884\u5b58\u6b3e\u91d1\u989d\uff1a{}", new Object[]{userId, appUid, point, deductAmount});
            this.deductPointRecordService.add(deductPointRecord);
            throw new ValidateException("\u6263\u9664\u5f00\u53d1\u8005\u79ef\u5206\u5931\u8d25");
        }
        deductPointRecord.setRemark(URLDecoder.decode(appPointDto.getErrorMessage(), "UTF-8"));
        this.log.warn("\u7528\u6237ID:{}\uff0cappUid\uff1a{}\uff0c\u6263\u9664\u79ef\u5206\u6570\u91cf:{}\uff0c\u6263\u9664\u9884\u5b58\u6b3e\u91d1\u989d\uff1a{}", new Object[]{userId, appUid, point, deductAmount});
        this.log.warn("\u8c03\u7528\u5f00\u53d1\u8005\u6263\u9664\u79ef\u5206\u63a5\u53e3\u51fa\u9519:{}", (Object)URLDecoder.decode(appPointDto.getErrorMessage(), "UTF-8"));
        this.deductPointRecordService.add(deductPointRecord);
        throw new ValidateException(URLDecoder.decode(appPointDto.getErrorMessage(), "UTF-8"));
    }

    private void deductUserPointConfirm(String appUid, ProviderApp providerApp, DeductPointRecord deductPointRecord, String orderNum, String status) throws ValidateException, Exception {
        String responseStr = "";
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("timestamp", System.currentTimeMillis());
            params.put("appKey", providerApp.getAppKey());
            params.put("status", status);
            params.put("appUid", appUid);
            params.put("description", "\u6263\u9664\u79ef\u5206\u6210\u529f\u786e\u8ba4\u901a\u77e5");
            params.put("orderNum", orderNum);
            String sign = MD5Util.sign(params, (String)providerApp.getAppSecret());
            params.put("sign", sign);
            if (StringUtil.isBlank((CharSequence)providerApp.getDeductAppPointConfirmApi())) {
                throw new ValidateException("\u6263\u9664\u79ef\u5206\u786e\u8ba4\u63a5\u53e3\u6ca1\u6709\u914d\u7f6e");
            }
            responseStr = OkHttpUtils.post((String)providerApp.getDeductAppPointConfirmApi(), params);
        }
        catch (Exception e) {
            this.log.error("\u8c03\u7528\u5f00\u53d1\u8005\u6263\u9664\u79ef\u5206\u63a5\u53e3\u51fa\u9519:responseStr--------{}", (Object)responseStr);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            this.log.error("---------> system huge error:{}", (Object)sw.toString());
            throw new ValidateException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }
}

