/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.app.timer;

import com.bxm.app.dal.mapper.ext.ProviderAppMapperExt;
import com.bxm.app.dal.model.ProviderApp;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="timmerUpdateBudgetPerDayBalance")
public class TimmerUpdateBudgetPerDayBalance {
    private final Logger log = Logger.getLogger(this.getClass());
    @Autowired
    private ProviderAppMapperExt providerAppMapperExt;

    public void updateBudgetPerDayBalance() {
        this.log.info((Object)"start update providerApp budgetPerDayBalance");
        boolean isLastDayOfMonth = this.isLastDayOfMonth(new Date());
        List providerAppList = this.providerAppMapperExt.getUpdateBudgetPerDayBalanceApp();
        for (ProviderApp providerApp : providerAppList) {
            if (isLastDayOfMonth) {
                providerApp.setBudgetPerMonthBalance(providerApp.getBudgetPerMonth());
            }
            providerApp.setBudgetPerDayBalance(providerApp.getBudgetPerDay());
            if (providerApp.getBudgetPerDayBalance().compareTo(new BigDecimal(0)) != 1 && providerApp.getBudgetPerMonth().compareTo(new BigDecimal(0)) != 1) continue;
            this.providerAppMapperExt.updateByPrimaryKeySelective(providerApp);
        }
        this.log.info((Object)"over update providerApp budgetPerDayBalance");
    }

    private boolean isLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.get(5) + 1);
        return calendar.get(5) == 1;
    }
}

