/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.app.config;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
@EnableCaching
public class RedisCacheConfiguration
extends CachingConfigurerSupport {
    @Value(value="${spring.redis.host}")
    private String host;
    @Value(value="${spring.redis.port}")
    private int port;
    @Value(value="${spring.redis.timeout}")
    private int timeout;
    @Value(value="${spring.redis.pool.max-idle}")
    private int minIdle;
    @Value(value="${spring.redis.pool.max-idle}")
    private int maxIdle;
    @Value(value="${spring.redis.pool.max-wait}")
    private long maxWaitMillis;
    @Value(value="${spring.redis.password}")
    private String password;
    @Value(value="${spring.redis.database}")
    private int database;
    @Value(value="${spring.redis.isrds}")
    private int isrds;

    @Bean
    public JedisPool redisPoolFactory() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMinIdle(this.minIdle);
        jedisPoolConfig.setMaxIdle(this.maxIdle);
        jedisPoolConfig.setMaxWaitMillis(this.maxWaitMillis);
        if (this.isrds == 1) {
            return new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, this.host, this.port, this.timeout, this.password, this.database);
        }
        return new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, this.host, this.port, this.timeout, null, this.database);
    }
}

