/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.app.config;

import com.bxm.util.SerializableUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component
public class RedisClient {
    @Autowired
    private JedisPool jedisPool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, String value) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.set(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String key, int seconds, String value) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.setex(key, seconds, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            String string = jedis.get(key);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(String key, Object value) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.set(key.getBytes(), SerializableUtil.toByteArray((Object)value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(String key, int seconds, Object value) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            jedis.setex(key.getBytes(), seconds, SerializableUtil.toByteArray((Object)value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String key) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            byte[] obj = jedis.get(key.getBytes());
            if (obj == null) {
                Object var4_4 = null;
                return var4_4;
            }
            Object object = SerializableUtil.toObject((byte[])obj);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delObject(String key) throws Exception {
        try (Jedis jedis = null;){
            jedis = this.jedisPool.getResource();
            if (jedis.exists(key).booleanValue()) {
                boolean bl = jedis.del(key) > 0L;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }
}

