/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.app.service;

import com.alibaba.fastjson.JSON;
import com.bxm.app.dal.mapper.ext.ProviderAppMapperExt;
import com.bxm.app.dal.mapper.ext.ProviderMapperExt;
import com.bxm.app.dal.model.DeductBalanceRecord;
import com.bxm.app.dal.model.DeductPointRecord;
import com.bxm.app.dal.model.Provider;
import com.bxm.app.dal.model.ProviderApp;
import com.bxm.app.model.dto.AppBalanceDto;
import com.bxm.app.service.DeductBalanceRecordService;
import com.bxm.app.service.DeductPointRecordService;
import com.bxm.util.MD5Util;
import com.bxm.util.OkHttpUtils;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ValidateException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppBalanceService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ProviderMapperExt providerMapperExt;
    @Autowired
    private ProviderAppMapperExt providerAppMapperExt;
    @Autowired
    private DeductPointRecordService deductPointRecordService;
    @Autowired
    private DeductBalanceRecordService deductBalanceRecordService;

    public BigDecimal getUserBalance(String appUid, String appKey) throws ValidateException, Exception {
        BigDecimal balance = new BigDecimal(0);
        ProviderApp providerApp = this.providerAppMapperExt.getByAppKey(appKey);
        if (providerApp == null) {
            this.log.warn("app\u4e0d\u5b58\u5728,appKey:{}", (Object)appKey);
            return balance;
        }
        if (StringUtil.isBlank((CharSequence)providerApp.getAppBalanceApi())) {
            this.log.warn("\u67e5\u8be2\u4f59\u989d\u63a5\u53e3\u6ca1\u6709\u914d\u7f6e,appKey:{}", (Object)appKey);
            return balance;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("timestamp", System.currentTimeMillis());
        params.put("appKey", providerApp.getAppKey());
        params.put("appUid", appUid);
        String sign = MD5Util.sign(params, (String)providerApp.getAppSecret());
        params.put("sign", sign);
        String responseStr = "";
        try {
            responseStr = OkHttpUtils.get((String)providerApp.getAppBalanceApi(), params);
            if (StringUtil.isNotBlank((CharSequence)responseStr)) {
                AppBalanceDto appBalanceDto = (AppBalanceDto)JSON.parseObject((String)responseStr, AppBalanceDto.class);
                if (appBalanceDto != null && appBalanceDto.getStatus().equals("ok") && appBalanceDto.getBalance() != null) {
                    return appBalanceDto.getBalance();
                }
                if (appBalanceDto.getErrorMessage() != null) {
                    this.log.warn("\u63a5\u53e3\u51fa\u9519:{}", (Object)URLDecoder.decode(appBalanceDto.getErrorMessage(), "UTF-8"));
                    return balance;
                }
                this.log.warn("\u63a5\u53e3\u51fa\u9519");
                return balance;
            }
        }
        catch (Exception e) {
            this.log.error("\u8c03\u7528\u5f00\u53d1\u8005\u67e5\u8be2\u4f59\u989d\u63a5\u53e3\u51fa\u9519:responseStr--------{}", (Object)responseStr);
            this.log.error("\u8c03\u7528\u5f00\u53d1\u8005\u67e5\u8be2\u4f59\u989d\u63a5\u53e3\u51fa\u9519:{}", (Object)e.getMessage());
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            this.log.error("---------> system huge error:{}", (Object)sw.toString());
            throw new ValidateException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return balance;
    }

    @Transactional
    public Boolean deductUserBalance(Long userId, String appUid, String appKey, String orderNum, BigDecimal deductAmount, Integer point, String remark) throws ValidateException, Exception {
        if (point == null || point <= 0) {
            throw new ValidateException("\u6263\u9664\u4f59\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        if (deductAmount == null || deductAmount.compareTo(new BigDecimal(0)) == -1) {
            throw new ValidateException("\u6263\u9664\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        ProviderApp providerApp = this.providerAppMapperExt.getByAppKey(appKey);
        if (providerApp == null) {
            this.log.warn("app\u4e0d\u5b58\u5728,appKey:{}", (Object)appKey);
            throw new ValidateException("\u62b1\u6b49,\u4f59\u989d\u4e0d\u8db3,\u8bf7\u5145\u503c");
        }
        if (StringUtil.isBlank((CharSequence)providerApp.getDeductAppBalanceApi())) {
            this.log.warn("\u6263\u9664\u4f59\u989d\u63a5\u53e3\u6ca1\u6709\u914d\u7f6e,appKey:{}", (Object)appKey);
            throw new ValidateException("\u62b1\u6b49,\u4f59\u989d\u4e0d\u8db3,\u8bf7\u5145\u503c");
        }
        Provider provider = this.providerMapperExt.selectByPrimaryKey(providerApp.getProviderId());
        this.checkParam(appUid, appKey, orderNum, deductAmount, provider);
        return this.deductBalance(userId, appUid, orderNum, deductAmount, point, remark, providerApp, provider);
    }

    private void checkParam(String appUid, String appKey, String orderNum, BigDecimal deductAmount, Provider provider) throws Exception {
        if (provider == null) {
            this.log.warn("app\u4e0d\u5b58\u5728,appKey:{}", (Object)appKey);
            throw new ValidateException("\u62b1\u6b49,\u4f59\u989d\u4e0d\u8db3,\u8bf7\u5145\u503c");
        }
        if (provider.getIsOpenBalance() == null || provider.getIsOpenBalance() == 0) {
            this.log.warn("\u6ca1\u6709\u5f00\u901a\u4f59\u989d\u652f\u4ed8,appKey:{}", (Object)appKey);
            throw new ValidateException("\u6ca1\u6709\u5f00\u901a\u4f59\u989d\u652f\u4ed8");
        }
        if (provider.getAdvancePayment() == null && provider.getAdvancePayment().compareTo(new BigDecimal(0)) != 1) {
            this.log.warn("\u9884\u5b58\u6b3e\u4e0d\u8db3,appKey:{}", (Object)appKey);
            throw new ValidateException("\u4eca\u65e5\u540d\u989d\u5df2\u6ee1");
        }
        if (deductAmount.compareTo(provider.getAdvancePayment()) == 1) {
            this.log.warn("app\u9884\u5b58\u6b3e\u4e0d\u8db3,appKey:{}", (Object)appKey);
            throw new ValidateException("\u62b1\u6b49,\u4f59\u989d\u4e0d\u8db3,\u8bf7\u5145\u503c");
        }
        DeductPointRecord deductPointRecordTmp = this.deductPointRecordService.getByOid(orderNum);
        if (deductPointRecordTmp != null && deductPointRecordTmp.getStatus() == 1) {
            this.log.warn("app\u8ba2\u5355\u5df2\u652f\u4ed8,appKey:{},\u8ba2\u5355\u53f7\uff1a{}", (Object)appKey, (Object)orderNum);
            throw new ValidateException("\u8ba2\u5355\u5df2\u652f\u4ed8");
        }
        BigDecimal balance = this.getUserBalance(appUid, appKey);
        if (balance.compareTo(new BigDecimal(0)) != 1 || balance.compareTo(deductAmount) != 1) {
            this.log.warn("app\u7528\u6237\u4f59\u989d\u4e0d\u8db3,appKey:{},appUid:{}", (Object)appKey, (Object)appUid);
            throw new ValidateException("\u62b1\u6b49,\u4f59\u989d\u4e0d\u8db3,\u8bf7\u5145\u503c");
        }
        DeductBalanceRecord deductBalanceRecord = this.deductBalanceRecordService.getByOid(orderNum);
        if (deductBalanceRecord != null) {
            throw new ValidateException("\u6b64\u8ba2\u5355\u652f\u4ed8\u8fc7\uff0c\u8bf7\u52ff\u91cd\u65b0\u652f\u4ed8");
        }
    }

    private Boolean deductBalance(Long userId, String appUid, String orderNum, BigDecimal deductAmount, Integer point, String remark, ProviderApp providerApp, Provider provider) throws Exception, IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("timestamp", System.currentTimeMillis());
        params.put("appKey", providerApp.getAppKey());
        params.put("appUid", appUid);
        params.put("balance", point);
        params.put("description", "\u6263\u9664\u4f59\u989d\u901a\u77e5");
        params.put("orderNum", orderNum);
        String sign = MD5Util.sign(params, (String)providerApp.getAppSecret());
        params.put("sign", sign);
        String responseStr = "";
        try {
            responseStr = OkHttpUtils.post((String)providerApp.getDeductAppBalanceApi(), params);
        }
        catch (Exception e) {
            this.log.error("\u8c03\u7528\u5f00\u53d1\u8005\u6263\u9664\u4f59\u989d\u63a5\u53e3\u51fa\u9519:responseStr--------{}", (Object)responseStr);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            this.log.error("---------> system huge error:{}", (Object)sw.toString());
            throw new ValidateException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        if (StringUtil.isBlank((CharSequence)responseStr)) {
            this.log.error("\u8c03\u7528\u5f00\u53d1\u8005\u6263\u9664\u79ef\u5206\u63a5\u53e3\u51fa\u9519:responseStr--------{}", (Object)responseStr);
            throw new ValidateException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        AppBalanceDto appBalanceDto = (AppBalanceDto)JSON.parseObject((String)responseStr, AppBalanceDto.class);
        if (appBalanceDto != null && appBalanceDto.getStatus().equals("ok")) {
            return this.deductSuccess(userId, appUid, orderNum, deductAmount, point, remark, providerApp, provider, appBalanceDto);
        }
        this.deductFail(userId, appUid, orderNum, deductAmount, point, providerApp.getId(), appBalanceDto);
        return false;
    }

    private Boolean deductSuccess(Long userId, String appUid, String orderNum, BigDecimal deductAmount, Integer point, String remark, ProviderApp providerApp, Provider provider, AppBalanceDto appBalanceDto) throws Exception {
        boolean isDeductSuccess = this.providerMapperExt.deductAdvancePayment(provider.getId(), deductAmount) == 1;
        DeductPointRecord deductPointRecord = new DeductPointRecord();
        deductPointRecord.setAppId(providerApp.getId());
        deductPointRecord.setAppOid(appBalanceDto.getAppOrderNum());
        deductPointRecord.setOid(orderNum);
        deductPointRecord.setPoint(point);
        deductPointRecord.setAppUid(appUid);
        deductPointRecord.setAmount(deductAmount);
        deductPointRecord.setAppStatus(Byte.valueOf((byte)1));
        deductPointRecord.setUserId(userId);
        deductPointRecord.setRemark(remark);
        if (isDeductSuccess) {
            deductPointRecord.setStatus(Byte.valueOf((byte)1));
            this.deductPointRecordService.add(deductPointRecord);
            DeductBalanceRecord deductBalanceRecordInsert = new DeductBalanceRecord();
            BeanUtils.copyProperties((Object)deductPointRecord, (Object)deductBalanceRecordInsert);
            this.deductBalanceRecordService.add(deductBalanceRecordInsert);
            this.deductUserBalanceConfirm(appUid, providerApp, deductPointRecord, orderNum, "ok");
            return true;
        }
        deductPointRecord.setStatus(Byte.valueOf((byte)0));
        deductPointRecord.setRemark("\u6263\u9664\u9884\u5b58\u6b3e\u5931\u8d25");
        this.deductPointRecordService.add(deductPointRecord);
        this.deductUserBalanceConfirm(appUid, providerApp, deductPointRecord, orderNum, "fail");
        return false;
    }

    private void deductFail(Long userId, String appUid, String orderNum, BigDecimal deductAmount, Integer point, Long appId, AppBalanceDto appBalanceDto) throws ValidateException, Exception {
        DeductPointRecord deductPointRecord = new DeductPointRecord();
        deductPointRecord.setAppId(appId);
        deductPointRecord.setAppOid(appBalanceDto.getAppOrderNum());
        deductPointRecord.setOid(orderNum);
        deductPointRecord.setAppUid(appUid);
        deductPointRecord.setAmount(deductAmount);
        deductPointRecord.setPoint(point);
        deductPointRecord.setAppStatus(Byte.valueOf((byte)0));
        deductPointRecord.setStatus(Byte.valueOf((byte)0));
        deductPointRecord.setUserId(userId);
        deductPointRecord.setRemark(URLDecoder.decode(appBalanceDto.getErrorMessage(), "UTF-8"));
        if (StringUtil.isBlank((CharSequence)appBalanceDto.getErrorMessage())) {
            deductPointRecord.setRemark("\u8c03\u7528\u5f00\u53d1\u8005\u6263\u9664\u4f59\u989d\u63a5\u53e3\u51fa\u9519");
        }
        this.log.warn("\u7528\u6237ID:{}\uff0cappUid\uff1a{}\uff0c\u6263\u9664\u4f59\u989d\u6570\u91cf:{}\uff0c\u6263\u9664\u9884\u5b58\u6b3e\u91d1\u989d\uff1a{}", new Object[]{userId, appUid, point, deductAmount});
        this.log.warn("\u8c03\u7528\u5f00\u53d1\u8005\u6263\u9664\u4f59\u989d\u63a5\u53e3\u51fa\u9519:{}", (Object)URLDecoder.decode(appBalanceDto.getErrorMessage(), "UTF-8"));
        this.deductPointRecordService.add(deductPointRecord);
        throw new ValidateException(URLDecoder.decode(appBalanceDto.getErrorMessage(), "UTF-8"));
    }

    private void deductUserBalanceConfirm(String appUid, ProviderApp providerApp, DeductPointRecord deductPointRecord, String orderNum, String status) throws ValidateException, Exception {
        String responseStr = "";
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("timestamp", System.currentTimeMillis());
            params.put("appKey", providerApp.getAppKey());
            params.put("status", status);
            params.put("appUid", appUid);
            params.put("description", "\u6263\u9664\u4f59\u989d\u6210\u529f\u786e\u8ba4\u901a\u77e5");
            params.put("orderNum", orderNum);
            String sign = MD5Util.sign(params, (String)providerApp.getAppSecret());
            params.put("sign", sign);
            if (StringUtil.isBlank((CharSequence)providerApp.getDeductAppBalanceConfirmApi())) {
                throw new ValidateException("\u6263\u9664\u4f59\u989d\u786e\u8ba4\u63a5\u53e3\u6ca1\u6709\u914d\u7f6e");
            }
            responseStr = OkHttpUtils.post((String)providerApp.getDeductAppBalanceConfirmApi(), params);
        }
        catch (Exception e) {
            this.log.error("\u8c03\u7528\u5f00\u53d1\u8005\u6263\u9664\u4f59\u989d\u786e\u8ba4\u63a5\u53e3\u51fa\u9519:responseStr--------{}", (Object)responseStr);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter((Writer)sw, true));
            this.log.error("---------> system huge error:{}", (Object)sw.toString());
            throw new ValidateException("\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }
}

