/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.app.service;

import com.bxm.app.dal.mapper.ext.AppEntranceFacadeMapperExt;
import com.bxm.app.dal.mapper.ext.ProviderMapperExt;
import com.bxm.app.model.dto.AppEntranceAdDto;
import com.bxm.app.model.dto.AuditAdPositionDto;
import com.bxm.app.model.ro.AppEntranceAdRo;
import com.bxm.util.CommonValidate;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppEntranceFacadeService {
    @Autowired
    private AppEntranceFacadeMapperExt appEntranceFacadeMapperExt;
    @Autowired
    private ProviderMapperExt providerMapperExt;

    public boolean updateAdPositionInfo(AppEntranceAdDto appEntranceDto) throws ValidateException, Exception {
        CommonValidate.me.checkParam((Object)appEntranceDto.getId());
        int result = this.appEntranceFacadeMapperExt.updateAdPositionInfo(appEntranceDto);
        return result == 1;
    }

    public AppEntranceAdRo getByPositionId(String positionId) throws ValidateException, Exception {
        CommonValidate.me.checkParam((Object)positionId);
        return this.appEntranceFacadeMapperExt.getByPositionId(positionId);
    }

    public List<AppEntranceAdRo> getList(String positionId, String keywords, Integer state) throws ValidateException, Exception {
        return this.appEntranceFacadeMapperExt.getList(positionId, keywords, state);
    }

    public PageInfo<AppEntranceAdRo> getAuditList(Integer pageNum, Integer pageSize, String positionId, String keywords, Integer state) throws ValidateException, Exception {
        if (pageSize > 50) {
            pageSize = 50;
        }
        PageHelper.startPage((int)pageNum, (int)pageSize);
        return new PageInfo(this.appEntranceFacadeMapperExt.getList(positionId, keywords, state));
    }

    public boolean auditAdPosition(AuditAdPositionDto auditAdPositionDto) throws ValidateException, Exception {
        CommonValidate.me.checkParam((Object)auditAdPositionDto.getState());
        if (auditAdPositionDto.getIds().size() == 0) {
            throw new ValidateException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.appEntranceFacadeMapperExt.auditAdPosition(auditAdPositionDto) > 0;
    }

    public List<AppEntranceAdRo> getPositionIdList(String appKey, Integer state) {
        if (CollectionUtils.isNotEmpty((Collection)this.appEntranceFacadeMapperExt.getList(null, null, state))) {
            return this.appEntranceFacadeMapperExt.getPositionIdList(appKey, state);
        }
        return new ArrayList<AppEntranceAdRo>();
    }

    public Integer queryDockMethod(String appKey, String appEntranceId) {
        return this.appEntranceFacadeMapperExt.queryDockMethod(appKey, appEntranceId);
    }
}

