/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.app.web.controller;

import com.bxm.app.service.AppBalanceService;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@EnableAutoConfiguration
@RefreshScope
@Api(description="\u5f00\u53d1\u8005\u7528\u6237\u4f59\u989d\u76f8\u5173\u63a5\u53e3")
public class AppBalanceController {
    @Autowired
    private AppBalanceService appBalanceService;

    @ApiOperation(value="\u83b7\u53d6app\u7528\u6237\u4f59\u989d", notes="\u83b7\u53d6app\u7528\u6237\u4f59\u989d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appUid", value="app\u7684\u7528\u6237\u8d26\u53f7", required=true, paramType="query", dataType="String"), @ApiImplicitParam(name="appId", value="appId", required=true, paramType="query", dataType="String")})
    @RequestMapping(value={"/getUserBalance"}, method={RequestMethod.GET})
    public ResultModel<BigDecimal> getUserBalance(@RequestParam(value="appUid", required=true) String appUid, @RequestParam(value="appKey", required=true) String appKey) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.appBalanceService.getUserBalance(appUid, appKey));
        return resultModel;
    }

    @ApiOperation(value="\u6263\u9664app\u7528\u6237\u4f59\u989d", notes="\u6263\u9664app\u7528\u6237\u4f59\u989d\uff08\u865a\u62df\u8d27\u5e01\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, paramType="query", dataType="int"), @ApiImplicitParam(name="appUid", value="app\u7684\u7528\u6237\u8d26\u53f7", required=true, paramType="query", dataType="String"), @ApiImplicitParam(name="appKey", value="appKey", required=true, paramType="query", dataType="String"), @ApiImplicitParam(name="orderNum", value="\u8ba2\u5355\u53f7", required=true, paramType="query", dataType="double"), @ApiImplicitParam(name="deductAmount", value="\u6263\u9664\u7684\u91d1\u989d", required=true, paramType="query", dataType="String"), @ApiImplicitParam(name="point", value="\u6263\u9664\u7684\u865a\u62df\u8d27\u5e01", required=true, paramType="query", dataType="int"), @ApiImplicitParam(name="remark", value="\u5907\u6ce8", required=true, paramType="query", dataType="String")})
    @RequestMapping(value={"/deductUserBalance"}, method={RequestMethod.POST})
    public ResultModel<Boolean> deductUserBalance(@RequestParam(value="userId", required=true) Long userId, @RequestParam(value="appUid", required=true) String appUid, @RequestParam(value="appKey", required=true) String appKey, @RequestParam(value="orderNum", required=true) String orderNum, @RequestParam(value="deductAmount", required=true) BigDecimal deductAmount, @RequestParam(value="point", required=true) Integer point, @RequestParam(value="remark", required=false) String remark) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.appBalanceService.deductUserBalance(userId, appUid, appKey, orderNum, deductAmount, point, remark));
        return resultModel;
    }
}

