/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.app.web.controller;

import com.bxm.app.config.RedisClient;
import com.bxm.app.dal.model.ProviderApp;
import com.bxm.app.service.ProviderAppService;
import com.bxm.util.DateUtil;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@EnableAutoConfiguration
@RefreshScope
@Api(description="\u5f00\u53d1\u8005app\u76f8\u5173\u63a5\u53e3")
public class ProviderAppController {
    @Autowired
    private ProviderAppService appService;
    @Autowired
    private RedisClient redisClient;

    @ApiIgnore
    @RequestMapping(value={"/doc"})
    public ModelAndView swaggerInfo() {
        String url = "redirect:swagger-ui.html";
        return new ModelAndView(url);
    }

    @ApiOperation(value="\u65b0\u589eapp", notes="\u6839\u636e\u4f20\u5165\u5bf9\u8c61\u65b0\u589eapp\u4fe1\u606f")
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public ResultModel<Long> add(@RequestBody ProviderApp providerApp) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.appService.add(providerApp));
        return resultModel;
    }

    @ApiOperation(value="\u4fee\u6539app", notes="\u6839\u636e\u4f20\u5165\u5bf9\u8c61\u4fee\u6539app\u4fe1\u606f")
    @RequestMapping(value={"/"}, method={RequestMethod.PUT})
    public ResultModel<Boolean> update(@RequestBody ProviderApp providerApp) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.appService.update(providerApp));
        return resultModel;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868", notes="\u5206\u9875\uff0c\u9ed8\u8ba410\u6761\u6bcf\u9875\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", value="\u9875\u7801", required=false, paramType="query", dataType="int"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6570\u91cf", required=false, paramType="query", dataType="int"), @ApiImplicitParam(name="orderParam", value="\u6392\u5e8f\u5b57\u6bb5\uff0c\u9ed8\u8ba4id\uff0ccreated\uff1a\u521b\u5efa\u65f6\u95f4", required=false, paramType="query", dataType="String"), @ApiImplicitParam(name="orderType", value="\u6392\u5e8f\u65b9\u5f0f\uff1aasc:\u987a\u5e8f\uff0cdesc\uff1a\u5012\u5e8f\uff0c\u9ed8\u8ba4\u5012\u5e8f", required=false, paramType="query", dataType="String"), @ApiImplicitParam(name="keywords", value="\u67e5\u8be2\u5173\u952e\u5b57\uff1aapp\u6807\u9898", required=false, paramType="query", dataType="String"), @ApiImplicitParam(name="startTime", value="\u521b\u5efa\u65f6\u95f4\u5f00\u59cb,\u65e5\u671f\u683c\u5f0f\uff0c\u59822017-08-08", required=false, paramType="query", dataType="date"), @ApiImplicitParam(name="endTime", value="\u521b\u5efa\u65f6\u95f4\u7ed3\u675f,\u59822017-08-08", required=false, paramType="query", dataType="date")})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<ProviderApp>> getList(@RequestParam(value="pageNum", required=false) Integer pageNum, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="orderParam", required=false) String orderParam, @RequestParam(value="orderType", required=false) String orderType, @RequestParam(value="keywords", required=false) String keywords, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        Date startTimeDate = StringUtil.isBlank((CharSequence)startTime) ? DateUtil.StringToDate((String)"1970-01-01") : DateUtil.StringToDate((String)startTime);
        Date endTimeDate = StringUtil.isBlank((CharSequence)endTime) ? new Date() : DateUtil.increaseDate((Date)DateUtil.StringToDate((String)endTime), (int)1);
        resultModel.setReturnValue((Object)this.appService.getList(Integer.valueOf(pageNum == null ? 1 : pageNum), Integer.valueOf(pageSize == null ? 10 : pageSize), orderParam, orderType, keywords, startTimeDate, endTimeDate));
        return resultModel;
    }

    @ApiOperation(value="\u6839\u636eappId\u83b7\u53d6app\u8be6\u7ec6\u4fe1\u606f", notes="\u6839\u636eurl\u4e2d\u7684appId\u67e5\u8be2\u8be6\u60c5")
    @ApiImplicitParam(name="id", value="appId", required=true, paramType="path", dataType="int")
    @RequestMapping(value={"/get/{id}"}, method={RequestMethod.GET})
    public ResultModel<ProviderApp> getById(@PathVariable(value="id") Long id) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.appService.getById(id));
        return resultModel;
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2app\u5217\u8868", notes="\u6839\u636eurl\u4e2d\u7684id\u67e5\u8be2\u5bf9\u8c61")
    @ApiImplicitParam(name="ids", value="appId,\u591a\u4e2a\u4ee5\u82f1\u6587\u534a\u89d2\u9017\u53f7\u5206\u5f00", required=true, paramType="query", dataType="String")
    @RequestMapping(value={"/getListByIds"}, method={RequestMethod.GET})
    public ResultModel<List<ProviderApp>> getListByIds(@RequestParam(value="ids", required=true) String ids) {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.appService.getListByIds(ids));
        return resultModel;
    }

    @ApiOperation(value="\u6839\u636eappKey\u67e5\u8be2app\u4fe1\u606f", notes="\u6839\u636eappKey\u67e5\u8be2app\u4fe1\u606f")
    @ApiImplicitParam(name="appKey", value="appKey", required=true, paramType="query", dataType="String")
    @RequestMapping(value={"/getByAppKey"}, method={RequestMethod.GET})
    public ResultModel<ProviderApp> getByAppKey(@RequestParam(value="appKey", required=true) String appKey) {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.appService.getByAppKey(appKey));
        return resultModel;
    }

    @ApiOperation(value="\u6839\u636eredisKey\u5220\u9664redis\u503c", notes="\u6839\u636eredisKey\u5220\u9664redis\u503c")
    @ApiImplicitParam(name="redisKey", value="redisKey", required=true, paramType="query", dataType="String")
    @RequestMapping(value={"/delRedisByKey"}, method={RequestMethod.DELETE})
    public ResultModel<Boolean> delRedisByKey(@RequestParam(value="redisKey", required=true) String redisKey) throws Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.redisClient.delObject(redisKey));
        return resultModel;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2id\u5217\u8868", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2id\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keywords", value="\u67e5\u8be2\u5173\u952e\u5b57\uff1aapp\u540d\u79f0\uff0c\u5f00\u53d1\u8005\u540d\u79f0", required=false, paramType="query", dataType="String"), @ApiImplicitParam(name="appId", value="appId", required=false, paramType="query", dataType="int")})
    @RequestMapping(value={"/getIdsByParams"}, method={RequestMethod.GET})
    public ResultModel<List<Long>> getIdsByParams(@RequestParam(value="keywords", required=false) String keywords, @RequestParam(value="appId", required=false) Long appId) {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.appService.getIdsByParams(keywords, appId));
        return resultModel;
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709app\u5217\u8868", notes="\u67e5\u8be2\u6240\u6709app\u5217\u8868")
    @RequestMapping(value={"/getList"}, method={RequestMethod.GET})
    public ResultModel<List<ProviderApp>> getList() {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.appService.getList());
        return resultModel;
    }

    @ApiOperation(value="\u5e7f\u544a\u90a3\u8fb9\u67e5\u8be2app\u5217\u8868", notes="\u5e7f\u544a\u90a3\u8fb9\u67e5\u8be2app\u5217\u8868")
    @RequestMapping(value={"/getListForAd"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<ProviderApp>> getListForAd(@RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="keyword", required=false) String keyword, @RequestParam(value="isFrozen", required=false) String isFrozen) {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.appService.getList(pageNum, pageSize, keyword, isFrozen));
        return resultModel;
    }

    @ApiOperation(value="\u6263\u9664\u5f00\u53d1\u8005\u9884\u5b58\u6b3e\u91d1\u989d", notes="\u6263\u9664\u5f00\u53d1\u8005\u9884\u5b58\u6b3e\u91d1\u989d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appId", value="appId", required=true, paramType="query", dataType="int"), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true, paramType="query", dataType="int"), @ApiImplicitParam(name="deductAmount", value="\u6263\u9664\u9884\u5b58\u6b3e\u91d1\u989d", required=true, paramType="query", dataType="String"), @ApiImplicitParam(name="orderNum", value="\u8ba2\u5355\u53f7", required=true, paramType="query", dataType="String"), @ApiImplicitParam(name="remark", value="\u5907\u6ce8", required=true, paramType="query", dataType="String")})
    @RequestMapping(value={"/deductAppAdvancePayment"}, method={RequestMethod.PUT})
    public ResultModel<Boolean> deductAppAdvancePayment(@RequestParam(value="appId", required=true) Long appId, @RequestParam(value="userId", required=true) Long userId, @RequestParam(value="deductAmount", required=true) BigDecimal deductAmount, @RequestParam(value="orderNum", required=true) String orderNum, @RequestParam(value="remark", required=false) String remark) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.appService.deductAppAdvancePayment(appId, userId, deductAmount, orderNum, remark));
        return resultModel;
    }

    @ApiOperation(value="\u589e\u52a0\u5f00\u53d1\u8005\u9884\u5b58\u6b3e\u91d1\u989d", notes="\u589e\u52a0\u5f00\u53d1\u8005\u9884\u5b58\u6b3e\u91d1\u989d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appId", value="appId", required=true, paramType="query", dataType="int"), @ApiImplicitParam(name="deductAmount", value="\u589e\u52a0\u9884\u5b58\u6b3e\u91d1\u989d", required=true, paramType="query", dataType="String"), @ApiImplicitParam(name="orderNum", value="\u8ba2\u5355\u53f7", required=true, paramType="query", dataType="String"), @ApiImplicitParam(name="remark", value="\u5907\u6ce8", required=true, paramType="query", dataType="String")})
    @RequestMapping(value={"/addAppAdvancePayment"}, method={RequestMethod.PUT})
    public ResultModel<Boolean> addAppAdvancePayment(@RequestParam(value="appId", required=true) Long appId, @RequestParam(value="deductAmount", required=true) BigDecimal deductAmount, @RequestParam(value="orderNum", required=true) String orderNum, @RequestParam(value="remark", required=false) String remark) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.appService.addAppAdvancePayment(appId, deductAmount, orderNum, remark));
        return resultModel;
    }
}

