/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.app.web.controller;

import com.bxm.app.dal.model.Provider;
import com.bxm.app.service.ProviderService;
import com.bxm.util.DateUtil;
import com.bxm.util.StringUtil;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@EnableAutoConfiguration
@RefreshScope
@RestController
@Api(description="\u5f00\u53d1\u8005\u6ce8\u518c\u8d26\u53f7\u76f8\u5173\u63a5\u53e3")
public class ProviderController {
    @Autowired
    private ProviderService providerService;

    @ApiOperation(value="\u65b0\u589eprovider", notes="\u6839\u636e\u4f20\u5165\u5bf9\u8c61\u65b0\u589eprovider\u4fe1\u606f")
    @RequestMapping(value={"/provider"}, method={RequestMethod.POST})
    public ResultModel<Long> add(@RequestBody Provider provider) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.providerService.add(provider));
        return resultModel;
    }

    @ApiOperation(value="\u4fee\u6539provider", notes="\u6839\u636e\u4f20\u5165\u5bf9\u8c61\u4fee\u6539provider\u4fe1\u606f")
    @RequestMapping(value={"/provider"}, method={RequestMethod.PUT})
    public ResultModel<Boolean> update(@RequestBody Provider provider) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.providerService.update(provider));
        return resultModel;
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5217\u8868", notes="\u5206\u9875\uff0c\u9ed8\u8ba410\u6761\u6bcf\u9875\u3002")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNum", value="\u9875\u7801", required=false, paramType="query", dataType="int"), @ApiImplicitParam(name="pageSize", value="\u6bcf\u9875\u6570\u91cf", required=false, paramType="query", dataType="int"), @ApiImplicitParam(name="orderParam", value="\u6392\u5e8f\u5b57\u6bb5\uff0c\u9ed8\u8ba4id\uff0ccreated\uff1a\u521b\u5efa\u65f6\u95f4", required=false, paramType="query", dataType="String"), @ApiImplicitParam(name="orderType", value="\u6392\u5e8f\u65b9\u5f0f\uff1aasc:\u987a\u5e8f\uff0cdesc\uff1a\u5012\u5e8f\uff0c\u9ed8\u8ba4\u5012\u5e8f", required=false, paramType="query", dataType="String"), @ApiImplicitParam(name="keywords", value="\u67e5\u8be2\u5173\u952e\u5b57\uff1aprovider\u6807\u9898", required=false, paramType="query", dataType="String"), @ApiImplicitParam(name="startTime", value="\u521b\u5efa\u65f6\u95f4\u5f00\u59cb,\u65e5\u671f\u683c\u5f0f\uff0c\u59822017-08-08", required=false, paramType="query", dataType="date"), @ApiImplicitParam(name="endTime", value="\u521b\u5efa\u65f6\u95f4\u7ed3\u675f,\u59822017-08-08", required=false, paramType="query", dataType="date"), @ApiImplicitParam(name="mobile", value="\u624b\u673a\u53f7\u7801", required=false, paramType="query", dataType="String"), @ApiImplicitParam(name="email", value="\u90ae\u7bb1", required=false, paramType="query", dataType="String"), @ApiImplicitParam(name="linkman", value="\u8054\u7cfb\u4eba", required=false, paramType="query", dataType="String")})
    @RequestMapping(value={"/provider"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<Provider>> getList(@RequestParam(value="pageNum", required=false) Integer pageNum, @RequestParam(value="pageSize", required=false) Integer pageSize, @RequestParam(value="orderParam", required=false) String orderParam, @RequestParam(value="orderType", required=false) String orderType, @RequestParam(value="keywords", required=false) String keywords, @RequestParam(value="startTime", required=false) String startTime, @RequestParam(value="endTime", required=false) String endTime, @RequestParam(value="mobile", required=false) String mobile, @RequestParam(value="email", required=false) String email, @RequestParam(value="linkman", required=false) String linkman) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        Date startTimeDate = StringUtil.isBlank((CharSequence)startTime) ? DateUtil.StringToDate((String)"1970-01-01") : DateUtil.StringToDate((String)startTime);
        Date endTimeDate = StringUtil.isBlank((CharSequence)endTime) ? new Date() : DateUtil.increaseDate((Date)DateUtil.StringToDate((String)endTime), (int)1);
        resultModel.setReturnValue((Object)this.providerService.getList(Integer.valueOf(pageNum == null ? 1 : pageNum), Integer.valueOf(pageSize == null ? 10 : pageSize), orderParam, orderType, keywords, startTimeDate, endTimeDate, mobile, email, linkman));
        return resultModel;
    }

    @ApiOperation(value="\u6839\u636eproviderId\u83b7\u53d6provider\u8be6\u7ec6\u4fe1\u606f", notes="\u6839\u636eurl\u4e2d\u7684providerId\u67e5\u8be2\u8be6\u60c5")
    @ApiImplicitParam(name="id", value="providerId", required=true, paramType="path", dataType="int")
    @RequestMapping(value={"/provider/{id}"}, method={RequestMethod.GET})
    public ResultModel<Provider> getById(@PathVariable(value="id") Long id) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.providerService.getById(id));
        return resultModel;
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2provider\u5217\u8868", notes="\u6839\u636eurl\u4e2d\u7684id\u67e5\u8be2\u5bf9\u8c61")
    @ApiImplicitParam(name="ids", value="providerId,\u591a\u4e2a\u4ee5\u82f1\u6587\u534a\u89d2\u9017\u53f7\u5206\u5f00", required=true, paramType="query", dataType="String")
    @RequestMapping(value={"/provider/getListByIds"}, method={RequestMethod.GET})
    public ResultModel<List<Provider>> getListByIds(@RequestParam(value="ids", required=true) String ids) {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.providerService.getListByIds(ids));
        return resultModel;
    }
}

