/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.app.web.controller.facade;

import com.bxm.app.model.dto.AppEntranceAdDto;
import com.bxm.app.model.dto.AuditAdPositionDto;
import com.bxm.app.model.ro.AppEntranceAdRo;
import com.bxm.app.service.AppEntranceFacadeService;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@EnableAutoConfiguration
@RefreshScope
@Api(description="\u5bf9\u5916\u63d0\u4f9b\u7684\u5f00\u53d1\u8005\u5e7f\u544a\u4f4d\u76f8\u5173\u63a5\u53e3")
@RequestMapping(value={"appEntranceFacade"})
public class AppEntranceFacadeController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppEntranceFacadeController.class);
    @Autowired
    private AppEntranceFacadeService appEntranceFacadeService;

    @ApiOperation(value="\u4fee\u6539\u5f00\u53d1\u8005\u5e7f\u544a\u4f4d\u76f8\u5173\u4fe1\u606f", notes="\u4fee\u6539\u5907\u6ce8\uff0c\u522b\u540d\uff0c\u884c\u4e1a\u7c7b\u578b")
    @RequestMapping(value={"/updateAdPositionInfo"}, method={RequestMethod.PUT})
    public ResultModel<Boolean> updateAdPositionInfo(@RequestBody AppEntranceAdDto appEntranceDto) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        try {
            LOGGER.info("\u8bf7\u6c42app\u7cfb\u7edf\u66f4\u65b0\u5e7f\u544a\u4f4d\u4fe1\u606f\u53c2\u6570:{}", (Object)appEntranceDto);
            boolean result = this.appEntranceFacadeService.updateAdPositionInfo(appEntranceDto);
            resultModel.setReturnValue((Object)result);
        }
        catch (Exception e) {
            LOGGER.error("\u8bf7\u6c42app\u7cfb\u7edf\u66f4\u65b0\u5e7f\u544a\u4f4d\u4fe1\u606f\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
        }
        LOGGER.info("\u8bf7\u6c42app\u7cfb\u7edf\u66f4\u65b0\u5e7f\u544a\u4f4d\u4fe1\u606f\u54cd\u5e94\u7ed3\u679c:{}", resultModel.getReturnValue());
        return resultModel;
    }

    @ApiOperation(value="\u6839\u636epositionId\u67e5\u8be2\u5e7f\u544a\u4f4d\u4fe1\u606f", notes="\u8fd4\u56de\u5f00\u53d1\u8005\u540d\u79f0,\u884c\u4e1a\u7c7b\u578b,\u5907\u6ce8,\u522b\u540d\u7b49\u4fe1\u606f")
    @ApiImplicitParam(name="positionId", value="\u5e7f\u544a\u4f4did", required=true, paramType="query", dataType="int")
    @RequestMapping(value={"/getByPositionId"}, method={RequestMethod.GET})
    public ResultModel<AppEntranceAdRo> getByPositionId(@RequestParam(value="positionId", required=true) String positionId) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        try {
            LOGGER.info("\u6839\u636epositionId\u67e5\u8be2\u5e7f\u544a\u4f4d\u4fe1\u606f,\u53c2\u6570:{}", (Object)positionId);
            resultModel.setReturnValue((Object)this.appEntranceFacadeService.getByPositionId(positionId));
        }
        catch (Exception e) {
            LOGGER.error("\u6839\u636epositionId\u67e5\u8be2\u5e7f\u544a\u4f4d\u4fe1\u606f,\u5f02\u5e38:", (Throwable)e);
        }
        return resultModel;
    }

    @ApiOperation(value="\u6839\u636e\u5173\u952e\u5b57\u67e5\u8be2\u5217\u8868", notes="\u9ed8\u8ba4\u67e5\u8be2\u5168\u90e8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="positionId", value="\u5e7f\u544a\u4f4did", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57\uff1aBD,\u5a92\u4ecb,\u5907\u6ce8", required=false, paramType="query", dataType="string")})
    @RequestMapping(value={"/getList"}, method={RequestMethod.GET})
    public ResultModel<List<AppEntranceAdRo>> getList(@RequestParam(value="positionId", required=false) String positionId, @RequestParam(value="keyword", required=false) String keywords) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.appEntranceFacadeService.getList(positionId, keywords, null));
        return resultModel;
    }

    @ApiOperation(value="\u6839\u636e\u5173\u952e\u5b57\u67e5\u8be2\u5217\u8868", notes="\u9ed8\u8ba4\u67e5\u8be2\u5168\u90e8")
    @ApiImplicitParams(value={@ApiImplicitParam(name="positionId", value="\u5e7f\u544a\u4f4did", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57\uff1aBD,\u5a92\u4ecb,\u5907\u6ce8\uff0c\u5e7f\u544a\u4f4did\uff0c\u5e7f\u544a\u4f4d\u540d\u79f0", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="state", value="\u72b6\u6001\uff1a", required=false, paramType="query", dataType="int")})
    @RequestMapping(value={"/getAuditList"}, method={RequestMethod.GET})
    public ResultModel<PageInfo<AppEntranceAdRo>> getAuditList(@RequestParam(value="pageNum", required=true) Integer pageNum, @RequestParam(value="pageSize", required=true) Integer pageSize, @RequestParam(value="positionId", required=false) String positionId, @RequestParam(value="keyword", required=false) String keywords, @RequestParam(value="state", required=false) Integer state) throws ValidateException, Exception {
        LOGGER.info("\u67e5\u8be2\u5ba1\u6838\u5217\u8868,\u8bf7\u6c42\u53c2\u6570:pageNum:{},pageSize:{},positionId:{},keyword:{},state:{}", new Object[]{pageNum, pageSize, positionId, keywords, state});
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.appEntranceFacadeService.getAuditList(pageNum, pageSize, positionId, keywords, state));
        return resultModel;
    }

    @ApiOperation(value="\u5ba1\u6838\u5e7f\u544a\u4f4d\u4fe1\u606f", notes="\u5ba1\u6838\u5e7f\u544a\u4f4d\u4fe1\u606f")
    @RequestMapping(value={"/auditAdPosition"}, method={RequestMethod.PUT})
    public ResultModel<Boolean> auditAdPosition(@RequestBody AuditAdPositionDto auditAdPositionDto) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.appEntranceFacadeService.auditAdPosition(auditAdPositionDto));
        return resultModel;
    }

    @ApiOperation(value="\u4e0d\u5206\u9875\u6839\u636e\u5355\u4e2a\u5a92\u4f53\u4e0b\u9762\u7684\u5e7f\u544a\u4f4d\u5217\u8868", notes="\u4e0d\u5206\u9875\u6839\u636e\u5355\u4e2a\u5a92\u4f53\u4e0b\u9762\u7684\u5e7f\u544a\u4f4d\u5217\u8868")
    @RequestMapping(value={"/getPositionIdList"}, method={RequestMethod.GET})
    public ResultModel<List<AppEntranceAdRo>> getPositionIdList(@RequestParam(value="state", required=false) Integer state, @RequestParam(value="appKey", required=true) String appKey) throws ValidateException, Exception {
        ResultModel resultModel = new ResultModel();
        resultModel.setReturnValue((Object)this.appEntranceFacadeService.getPositionIdList(appKey, state));
        return resultModel;
    }

    @ApiOperation(value="\u67e5\u8be2\u5e7f\u544a\u4f4d\u5bf9\u63a5\u65b9\u5f0f", notes="\u67e5\u8be2\u5e7f\u544a\u4f4d\u5bf9\u63a5\u65b9\u5f0f")
    @RequestMapping(value={"/queryDockMethod"}, method={RequestMethod.GET})
    public ResultModel<Integer> queryDockMethod(@RequestParam(value="appKey") String appKey, @RequestParam(value="appEntranceId") String appEntranceId) {
        ResultModel resultModel = new ResultModel();
        try {
            LOGGER.info("\u67e5\u8be2\u5e7f\u544a\u4f4d\u5bf9\u63a5\u65b9\u5f0f,\u8bf7\u6c42\u53c2\u6570:appKey={},appEntranceId={}", (Object)appKey, (Object)appEntranceId);
            resultModel.setReturnValue((Object)this.appEntranceFacadeService.queryDockMethod(appKey, appEntranceId));
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u5e7f\u544a\u4f4d\u5bf9\u63a5\u65b9\u5f0f\u53d1\u751f\u672a\u77e5\u9519\u8bef", (Throwable)e);
            resultModel.setSuccessed(false);
        }
        return resultModel;
    }
}

