/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.app.web.handler;

import com.bxm.util.dto.ErrorCode;
import com.bxm.util.dto.ResultModel;
import com.bxm.util.dto.ValidateException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@ControllerAdvice(annotations={RestController.class})
public class GlobalControllerExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalControllerExceptionHandler.class);

    @ExceptionHandler
    @ResponseBody
    private ResultModel<Boolean> runtimeExceptionHandler(Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)sw, true));
        LOGGER.error("---------> system huge error:{}", (Object)sw.toString());
        ResultModel result = new ResultModel();
        result.setSuccessed(false);
        result.setErrorCode(ErrorCode.SERVER_ERROR.getErrorCode());
        result.setErrorDesc(ErrorCode.SERVER_ERROR.getErrorMessage());
        return result;
    }

    @ExceptionHandler(value={ValidateException.class})
    @ResponseBody
    private ResultModel<Boolean> validateExceptionHandler(ValidateException e) {
        LOGGER.warn("---------> system validateException error:{}", (Object)e.getMessage());
        ResultModel result = new ResultModel();
        result.setSuccessed(false);
        result.setErrorCode(e.getErrorCode());
        result.setErrorDesc(e.getMessage());
        return result;
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    @ResponseBody
    private ResultModel<Boolean> missingServletRequestParameterExceptionHandler(MissingServletRequestParameterException e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)sw, true));
        LOGGER.warn("---------> system huge error:{}", (Object)sw.toString());
        ResultModel result = new ResultModel();
        result.setSuccessed(false);
        result.setErrorCode(ErrorCode.ILLEGAL_PARAMS.getErrorCode());
        result.setErrorDesc(ErrorCode.ILLEGAL_PARAMS.getErrorMessage());
        return result;
    }

    @ExceptionHandler(value={ServletRequestBindingException.class})
    @ResponseBody
    private ResultModel<Boolean> servletRequestBindingExceptionHandler(ServletRequestBindingException e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)sw, true));
        LOGGER.warn("---------> system huge error:{}", (Object)sw.toString());
        ResultModel result = new ResultModel();
        result.setSuccessed(false);
        result.setErrorCode(ErrorCode.ILLEGAL_PARAMS.getErrorCode());
        result.setErrorDesc(ErrorCode.ILLEGAL_PARAMS.getErrorMessage());
        return result;
    }
}

