package com.bxm.mccms.common.core.entity;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.mccms.common.model.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/1/9 16:50
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class DeveloperBill extends BaseEntity {

    private static final long serialVersionUID = 4070266063747628800L;

    public static final BigDecimal INIT_INCOME = new BigDecimal("0.0");
    /**
     * 状态：0待确认账单，1已经确认账单，2申请提现中，3提现拒绝，4，已经提现，-1，其他
     */
    public static final int OTHER = -1;
    public static final int UNCONFIRMED = 0;
    public static final int BXM_CONFIRMED = 1;
    public static final int DEVELOPER_CONFIRMED = 2;
    public static final int WITHDRAWALING = 3;
    public static final int WITHDRAWAL_REFUSE = 4;
    public static final int WITHDRAWAL_ALREADY = 5;
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 日期
     */
    private String month;

    /**
     * 开发者id
     */
    private Long developerId;

    /**
     * 业务类型
     */
    private Integer businessType =1 ;

    /**
     * 平台总消耗
     */
    private BigDecimal totalConsume;

    /**
     * 开发者实际收入
     */
    private BigDecimal developerIncome;

    /**
     * 可提现金额
     */
    private BigDecimal cashMoney ;

    private BigDecimal deductionMoney = INIT_INCOME;

    private String deductionLog = "";

    private String createUser = "admin";

    private Date createTime;

    private String modifyUser;

    private Date modifyTime;

    /**
     * 状态：0待确认账单，1已经确认账单，2申请提现中，3提现拒绝，4，已经提现，-1，其他
     */
    private Integer status = UNCONFIRMED;


    public static final String ID = "id";

    public static final String MONTH = "month";

    public static final String DEVELOPER_ID = "developer_id";

    public static final String BUSINESS_TYPE = "business_type";

    public static final String TOTAL_CONSUME = "total_consume";

    public static final String DEVELOPER_INCOME = "developer_income";

    public static final String CASH_MONEY = "cash_money";

    public static final String DEDUCTION_MONEY = "deduction_money";

    public static final String DEDUCTION_LOG = "deduction_log";

    public static final String CREATE_USER = "create_user";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_USER = "modify_user";

    public static final String MODIFY_TIME = "modify_time";

    public static final String STATUS = "status";

}
