package com.bxm.mccms.common.core.entity;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.mccms.common.model.base.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author hcmony
 * @since 2020-01-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class DeveloperIncome extends BaseEntity {

    /**
     * 状态：0未提交，1已经提交，2已经确认，
     */
    public static final int NO_SUBMIT = 0;
    public static final int READY_SUBMIT = 1;
    public static final int FINISH_SUBMIT = 2;
    public static final BigDecimal INIT_INCOME = new BigDecimal("0.0");

    private static final long serialVersionUID = -5398690898105262400L;
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    private String datetime;

    /**
     * 开发者id
     */
    private Long developerId;

    /**
     * 总请求量
     */
    private Long totalSend;

    /**
     * 总曝光量
     */
    private Long totalOpen;

    /**
     * 总点击量
     */
    private Long totalClick;

    /**
     * 上游平台预估消耗
     */
    private BigDecimal totalIncome;

    /**
     * 开发者预估收益
     */
    private BigDecimal developerPreIncome;

    private BigDecimal bxmPreIncome;

    /**
     * 状态：0未提交，1已经提交，2已经确认
     */
    private Integer status = NO_SUBMIT;

    private String createUser = "admin";

    private Date createTime;

    private String modifyUser;

    private Date modifyTime;

    private String remark;


    public static final String ID = "id";

    public static final String DATETIME = "datetime";

    public static final String DEVELOPER_ID = "developer_id";

    public static final String TOTAL_SEND = "total_send";

    public static final String TOTAL_OPEN = "total_open";

    public static final String TOTAL_CLICK = "total_click";

    public static final String TOTAL_INCOME = "total_income";

    public static final String DEVELOPER_PRE_INCOME = "developer_pre_income";

    public static final String BXM_PRE_INCOME = "bxm_pre_income";

    public static final String STATUS = "status";

    public static final String CREATE_USER = "create_user";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_USER = "modify_user";

    public static final String MODIFY_TIME = "modify_time";

    public static final String REMARK = "remark";

}
