package com.bxm.mccms.common.core.entity;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.mccms.common.model.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * "bankName": "试银行开户212",
 * 			"bankBranchName": "浙江杭州",
 *             "accountName": "范范22",
 *             "accountNumber": "fanjuan1",
 *             "cashMoney": 100,
 *             "month": "2020-01",
 *             "companyName": "小鱼赚钱有限公司",
 *             "withdrawalTime": "申请时间：2019-11-11 16:29:07付款时间：2019-10-12 14:09:44",
 * </p>
 *
 * @author hcmony
 * @since 2020-01-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class DeveloperWithdrawal extends BaseEntity {

    private static final long serialVersionUID = -1L;
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 开发者ID
     */
    private Long developerId;

    /**
     * 开发者名称
     */
    private String developerName;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 证件信息
     */
    private String licenseNo;

    /**
     * 营业执照
     */
    private String licensePicUrl;

    /**
     * 开户许可证
     */
    private String openingPermitPicUrl;

    /**
     * 开户银行信息
     */
    private String bankInfo;

    /**
     * 提现信息
     */
    private String withdrawalInfo;

    /**
     * 提现时间
     */
    private Date withdrawalTime;

    /**
     * 公司信息
     */
    private String companyInfo;

    /**
     * 状态：0待确认账单，1已经确认账单，2申请提现中，3提现拒绝，4，已经提现，-1，其他
     */
    private Integer status;

    private String createUser;

    private Date createTime;

    private String modifyUser;

    private Date modifyTime;

    /**
     * 日期
     */
    private String month;

    /**
     * 可提现金额
     */
    private BigDecimal cashMoney;
    /**
     * 开发者收益
     */
    private BigDecimal developerIncome;

    public static final String CASH_MONEY = "cash_money";
    public static final String DEVELOPER_INCOME = "developer_income";
    public static final String COMPANY_INFO = "company_info";

    public static final String MONTH = "month";

    public static final String ID = "id";

    public static final String DEVELOPER_ID = "developer_id";

    public static final String DEVELOPER_NAME = "developer_name";

    public static final String COMPANY_NAME = "company_name";

    public static final String LICENSE_NO = "license_no";

    public static final String LICENSE_PIC_URL = "license_pic_url";

    public static final String OPENING_PERMIT_PIC_URL = "opening_permit_pic_url";

    public static final String BANK_INFO = "bank_info";

    public static final String WITHDRAWAL_INFO = "withdrawal_info";

    public static final String WITHDRAWAL_TIME = "withdrawal_time";

    public static final String STATUS = "status";

    public static final String CREATE_USER = "create_user";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_USER = "modify_user";

    public static final String MODIFY_TIME = "modify_time";

}
