package com.bxm.mccms.common.core.entity;

import java.util.Date;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.mccms.common.model.base.BaseEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 广告平台
 * </p>
 *
 * @author Allen Hu
 * @since 2019-12-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class Dsp extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 平台代号,唯一约束，一般是广告平台的英文或拼音代号。
     */
    //@NotBlank(message = "平台代号不能为空！")
    private String dspCode;

    /**
     * 广告平台名称
     */
    @NotBlank(message = "广告平台名称不能为空！")
    private String dspName;

    /**
     * 接口地址
     */
    //@NotBlank(message = "接口地址不能为空！")
    private String apiUrl;

    /**
     * 接口密钥
     */
    private String apiKey;

    /**
     * 扩展属性,当通用配置无法满足对接时，请将需要的属性按照JSON格式填在这个字段中。
     */
    private String ext;

    /**
     * 连接超时设置,单位为毫秒
     */
    @NotNull(message = "连接超时设置不能为空！")
    private Integer connectTimeOut;

    /**
     * 读取结果超时设置,单位为毫秒
     */
    @NotNull(message = "读取结果超时设置不能为空！")
    private Integer socketTimeOut;

    /**
     * QPS限制
     */
    @NotNull(message = "QPS不能为空！")
    private Integer qps;

    /**
     * 备注
     */
    private String remark;

    /**
     * 是否删除,1:已删除
     */
    private Integer deleted;

    /**
     * 创建用户
     */
    private String createUser;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新用户
     */
    private String modifyUser;

    /**
     * 更新时间
     */
    private Date modifyTime;


    public static final String ID = "id";

    public static final String DSP_CODE = "dsp_code";

    public static final String DSP_NAME = "dsp_name";

    public static final String API_URL = "api_url";

    public static final String API_KEY = "api_key";

    public static final String EXT = "ext";

    public static final String CONNECT_TIME_OUT = "connect_time_out";

    public static final String SOCKET_TIME_OUT = "socket_time_out";

    public static final String QPS = "qps";

    public static final String REMARK = "remark";

    public static final String DELETED = "deleted";

    public static final String CREATE_USER = "create_user";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_USER = "modify_user";

    public static final String MODIFY_TIME = "modify_time";

}
