package com.bxm.mccms.common.core.entity;

import com.baomidou.mybatisplus.annotation.IdType;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.mccms.common.model.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 创意审核
 * </p>
 *
 * @author Allen Hu
 * @since 2019-12-23
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class DspCreative extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * DSP ID
     */
    private Long dspId;

    /**
     * DSP创意ID
     */
    private String dspCrtid;

    /**
     * DSP广告主ID
     */
    private String dspAdvtid;

    /**
     * 风控审核态,0:待审核,1:机审通过,2:机审不通过,3:通过,4:不通过
     */
    private Integer auditStatus;

    /**
     * 失败原因
     */
    private String failReason;

    /**
     * 广告类型：1普通链接落地页；2安卓下载；3IOS下载
     */
    private Integer type;

    /**
     * 下载类的 app id。如果 type 为 2 或 3，则必填
     */
    private String appId;

    /**
     * 跳转地址,广告类型为落地页：落地页地址,为下载类：下载地址,为deeplink：depplink路径
     */
    private String jumpUrl;

    /**
     * 应用跳转URL；type=1时跳转APP不存在则在应用内置浏览器打开链接；type=2时跳转安卓市场下载；type=3时跳转appstore下载
     */
    private String deepLinkUrl;
    /**
     * 创意标题
     */
    private String creativeTitle;

    /**
     * 创意内容,如：["内容1","内容2"]
     */
    private String creativeContent;

    /**
     * 原生广告的提示动作语：比如查看详情，点击下载
     */
    private String creativeActionText;
    /**
     * 创意图片,如：[{"url":"图片地址","w":"宽度","h":"高度","ds":"磁盘存储大小,单位:B","fmt":"格式,如:JPG"}]
     */
    private String creativePicture;

    /**
     * 创意视频,如：{"url":"视频地址","w":"宽度","h":"高度","ds":"磁盘存储大小,单位:B","fmt":"格式,如:MP4","dt":"时长,毫秒"}
     */
    private String creativeVideo;

    /**
     * 推送时间
     */
    private Date pushTime;

    /**
     * 审核时间
     */
    private Date auditTime;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date modifyTime;


    public static final String ID = "id";

    public static final String DSP_ID = "dsp_id";

    public static final String DSP_CRTID = "dsp_crtid";

    public static final String DSP_ADVTID = "dsp_advtid";

    public static final String AUDIT_STATUS = "audit_status";

    public static final String TYPE = "type";

    public static final String JUMP_URL = "jump_url";

    public static final String CREATIVE_ICON = "creative_icon";

    public static final String CREATIVE_TITLE = "creative_title";

    public static final String CREATIVE_CONTENT = "creative_content";

    public static final String CREATIVE_PICTURE = "creative_picture";

    public static final String CREATIVE_COVER = "creative_cover";

    public static final String CREATIVE_VIDEO = "creative_video";

    public static final String PUSH_TIME = "push_time";

    public static final String AUDIT_TIME = "audit_time";

    public static final String REMARK = "remark";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_TIME = "modify_time";

}
