package com.bxm.mccms.common.core.entity;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.mccms.common.model.base.BaseEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 广告位合作计费模式配置
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-01-10
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PositionCalcConfig extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 广告位id标识
     */
    private String positionId;

    /**
     * 合作类型： 1 分成，2 竞价，3 合约
     */
    private Integer cooperationType;

    /**
     * 分成比例
     */
    private BigDecimal divideInto;

    /**
     * 竞价类型：1 CPM，2 CPC，3 CPA
     */
    private Integer biddingType;

    /**
     * 价格，合作类型为竞价时单位为 元/CPM，合作类型为包段时单位为 元/天
     */
    private BigDecimal basePrice;

    /**
     * 包段开始时间
     */
    private LocalDate startDate;

    /**
     * 包段结束时间
     */
    private LocalDate endDate;

    /**
     * 合作类型： 1 分成，2 竞价，3 合约
     */
    private Integer oldCooperationType;

    /**
     * 分成比例
     */
    private BigDecimal oldDivideInto;

    /**
     * 竞价类型：1 CPM，2 CPC，3 CPA
     */
    private Integer oldBiddingType;

    /**
     * 价格，合作类型为竞价时单位为 元/CPM，合作类型为包段时单位为 元/天
     */
    private BigDecimal oldBasePrice;

    /**
     * 包段开始时间
     */
    private LocalDate oldStartDate;

    /**
     * 包段结束时间
     */
    private LocalDate oldEndDate;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private String modifyUser;

    /**
     * 修改时间
     */
    private Date modifyTime;


    public static final String ID = "id";

    public static final String POSITION_ID = "position_id";

    public static final String COOPERATION_TYPE = "cooperation_type";

    public static final String DIVIDE_INTO = "divide_into";

    public static final String BIDDING_TYPE = "bidding_type";

    public static final String BASE_PRICE = "base_price";

    public static final String START_DATE = "start_date";

    public static final String END_DATE = "end_date";

    public static final String OLD_COOPERATION_TYPE = "old_cooperation_type";

    public static final String OLD_DIVIDE_INTO = "old_divide_into";

    public static final String OLD_BIDDING_TYPE = "old_bidding_type";

    public static final String OLD_BASE_PRICE = "old_base_price";

    public static final String OLD_START_DATE = "old_start_date";

    public static final String OLD_END_DATE = "old_end_date";

    public static final String CREATE_USER = "create_user";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_USER = "modify_user";

    public static final String MODIFY_TIME = "modify_time";

}
