package com.bxm.mccms.common.core.entity;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.mccms.common.model.base.BaseEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 广告位渠道收益记录
 * </p>
 *
 * @author zhengwangeng
 * @since 2021-01-15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PositionChannelIncome extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 数据ID：时间+渠道+广告位组合的字符串
     */
    private String dataId;

    /**
     * 日期
     */
    private Date datetime;

    /**
     * 开发者id
     */
    private Long developerId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 广告位id
     */
    private String positionId;

    /**
     * 渠道
     */
    private String sdkChannelType;

    /**
     * 曝光量
     */
    private Long totalOpen;

    /**
     * 点击量
     */
    private Long totalClick;

    /**
     * 收益
     */
    private BigDecimal totalIncome;

    /**
     * 分成比率
     */
    private BigDecimal divideInto;

    /**
     * 公司收益
     */
    private BigDecimal bxmIncome;

    /**
     * 开发者收益
     */
    private BigDecimal developerIncome;

    private String createUser;

    private Date createTime;

    private String modifyUser;

    private Date modifyTime;


    public static final String ID = "id";

    public static final String DATETIME = "datetime";

    public static final String DATA_ID = "data_id";

    public static final String DEVELOPER_ID = "developer_id";

    public static final String APP_ID = "app_id";

    public static final String POSITION_ID = "position_id";

    public static final String SDK_CHANNEL_TYPE = "sdk_channel_type";

    public static final String TOTAL_OPEN = "total_open";

    public static final String TOTAL_CLICK = "total_click";

    public static final String TOTAL_INCOME = "total_income";

    public static final String DIVIDE_INTO = "divide_into";

    public static final String BXM_INCOME = "bxm_income";

    public static final String DEVELOPER_INCOME = "developer_income";

    public static final String CREATE_USER = "create_user";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_USER = "modify_user";

    public static final String MODIFY_TIME = "modify_time";

}
