package com.bxm.mccms.common.core.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.bxm.mccms.common.model.base.BaseEntity;

import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 广告位创意审核
 * </p>
 *
 * @author Allen Hu
 * @since 2019-12-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PositionDspCreative extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 广告位ID
     */
    private String positionId;

    /**
     * 创意库ID
     */
    private Long creativeId;

    /**
     * 审核状态,0:待审核,1:通过,2:不通过
     */
    private Integer auditStatus;

    /**
     * 审核时间
     */
    private Date auditTime;

    /**
     * 备注
     */
    private String remark;

    /**
     * 更新用户,审核用户
     */
    private String modifyUser;


    public static final String ID = "id";

    public static final String POSITION_ID = "position_id";

    public static final String CREATIVE_ID = "creative_id";

    public static final String AUDIT_STATUS = "audit_status";

    public static final String AUDIT_TIME = "audit_time";

    public static final String REMARK = "remark";

    public static final String MODIFY_USER = "modify_user";

}
