package com.bxm.mccms.common.core.entity;

import com.bxm.mccms.common.model.base.BaseEntity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 广告位流量分配
 * </p>
 *
 * @author Allen Hu
 * @since 2019-12-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PositionDspPos extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 广告位ID
     */
    private String positionId;

    /**
     * DSP ID
     */
    private Long dspId;

    /**
     * DSP广告位ID
     */
    private String dspPosid;

    /**
     * DSP应用ID
     */
    private String dspAppid;

    /**
     * 优先级,1~5升序
     */
    private Integer priority;

    /**
     * 放量底价
     */
    private BigDecimal dspBasePrice;

    /**
     * 流量开关,1:开,0:关
     */
    private Integer opened;

    /**
     * 创建用户
     */
    private String createUser;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新用户
     */
    private String modifyUser;

    /**
     * 更新时间
     */
    private Date modifyTime;


    public static final String ID = "id";

    public static final String POSITION_ID = "position_id";

    public static final String DSP_ID = "dsp_id";

    public static final String DSP_POSID = "dsp_posid";

    public static final String DSP_APPID = "dsp_appid";

    public static final String PRIORITY = "priority";

    public static final String DSP_BASE_PRICE = "dsp_base_price";

    public static final String OPENED = "opened";

    public static final String CREATE_USER = "create_user";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_USER = "modify_user";

    public static final String MODIFY_TIME = "modify_time";

}
