package com.bxm.mccms.common.core.entity;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.mccms.common.model.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/1/9 16:50
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PositionIncome extends BaseEntity {

    /**
     * 初始化收益值
     */
    public static final BigDecimal INIT_INCOME = new BigDecimal("0.0");
    public static final BigDecimal CPM_BASE = new BigDecimal("1000");
    public static final BigDecimal DIVIDEINTO_BASE = new BigDecimal("100");

    /**
     * 状态：0未提交，1已经提交，2已经确认，
     */
    public static final int NO_SUBMIT = 0;
    public static final int READY_SUBMIT = 1;
    public static final int FINISH_SUBMIT = 2;

    /**
     *  结算方式 1 分成，2 竞价，3 合约
     */
    public static final int SETTLE_TYPE_DIVIDEINTO = 1;
    public static final int SETTLE_TYPE_BIDDING = 2;
    public static final int SETTLE_TYPE_CONTRACT = 3;


    /**
     *  竞价类型：1 CPM，2 CPC，3 CPA
     */
    public static final int CPM =1;
    public static final int CPC =2;
    public static final int CPA =3;
    /**
     *  广告位对接方式 对接类型：1 API，2 SDK
     */
    public static final int DOCKING_METHOD_TYPE_API = 1;
    public static final int DOCKING_METHOD_TYPE_SDK = 2;

    /**
     * dsp类型：1 标准广告，2 组件，3 互动
     */
    public static final int DSP_TYPE_B = 1;

    private static final long serialVersionUID = 7666388002294592618L;
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 日期
     */
    private String datetime;

    /**
     * 开发者id
     */
    private Long developerId;

    /**
     * 广告位id
     */
    private String positionId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 总请求量
     */
    private Long totalSend;

    /**
     * 总曝光量
     */
    private Long totalOpen;

    /**
     * 总点击量
     */
    private Long totalClick;

    private Long uv;

    /**
     * 竞价消耗
     */
    private BigDecimal biddingConsume = INIT_INCOME;

    /**
     * 包段消耗
     */
    private BigDecimal bagConsume = INIT_INCOME;

    /**
     * 兜底消耗
     */
    private BigDecimal standbyConsume = INIT_INCOME;

    /**
     * 公司预估收益
     */
    private BigDecimal bxmPreIncome = INIT_INCOME;

    /**
     * 开发者预估收益
     */
    private BigDecimal positionPreIncome = INIT_INCOME;

    private String createUser = "admin";

    private Date createTime;

    private String modifyUser;

    private Date modifyTime;

    /**
     * 状态：0未提交，1已经提交，2已经确认，
     */
    private Integer status = NO_SUBMIT;

    /**
     * 备注
     */
    private String remark;

    /**
     * 修改日志id
     */
    private Long modifyLogId = 0L;

    /**
     * 上游DSPid
     */
    private Long dspId;

    /**
     * 结算方式 1 分成，2 竞价，3 合约
     */
    private Integer settleType = SETTLE_TYPE_DIVIDEINTO ;

    /**
     * 上游平台消耗
     */
    private BigDecimal totalIncome = INIT_INCOME;

    /**
     * 结算配置
     */
    private String settleConfig;

    /**
     *  广告位对接方式 对接类型：1 API，2 SDK
     */
    private Integer dockingMethodType;

    /**
     * dsp类型：1 标准广告，2 组件，3 互动
     */
    private Integer dspType;

    /**
     * 广告位场景：详情请看枚举
     */
    private Integer positionScene;

    private String sdkChannelType = "bxm_channel";

    public static final String ID = "id";

    public static final String DATETIME = "datetime";

    public static final String DEVELOPER_ID = "developer_id";

    public static final String POSITION_ID = "position_id";

    public static final String APP_ID = "app_id";

    public static final String TOTAL_SEND = "total_send";

    public static final String TOTAL_OPEN = "total_open";

    public static final String TOTAL_CLICK = "total_click";

    public static final String UV = "uv";

    public static final String BIDDING_CONSUME = "bidding_consume";

    public static final String BAG_CONSUME = "bag_consume";

    public static final String STANDBY_CONSUME = "standby_consume";

    public static final String BXM_PRE_INCOME = "bxm_pre_income";

    public static final String POSITION_PRE_INCOME = "position_pre_income";

    public static final String CREATE_USER = "create_user";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_USER = "modify_user";

    public static final String MODIFY_TIME = "modify_time";

    public static final String STATUS = "status";

    public static final String REMARK = "remark";

    public static final String MODIFY_LOG_ID = "modify_log_id";

    public static final String DSP_ID = "dsp_id";

    public static final String SETTLE_TYPE = "settle_type";

    public static final String TOTAL_INCOME = "total_income";
    public static final String SETTLE_CONFIG = "settle_config";

    public static final String DOCKING_METHOD_TYPE = "docking_method_type";
    public static final String DSP_TYPE = "dsp_type";
    public static final String POSITION_SCENE = "position_scene";
    public static final String SDK_CHANNEL_TYPE = "sdk_channel_type";
}
