package com.bxm.mccms.common.core.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.mccms.common.model.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 广告位屏蔽策略引用关系
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-01-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class PositionShieldStrategyRef extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 广告位ID
     */
    private String positionId;

    /**
     * 屏蔽策略ID
     */
    private Long shieldStrategyId;


    public static final String ID = "id";

    public static final String POSITION_ID = "position_id";

    public static final String SHIELD_STRATEGY_ID = "shield_strategy_id";

}
