package com.bxm.mccms.common.core.entity;

import java.math.BigDecimal;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.mccms.common.model.base.BaseEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 收款
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-07-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class Receipt extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 公司类型
     */
    private String companyType;

    /**
     * 业务名称
     */
    private String business;

    /**
     * 财务类型
     */
    private String financialType;

    /**
     * 开票类型
     */
    private String invoiceType;

    /**
     * 月份
     */
    private String month;

    /**
     * 变现猫预估收益
     */
    private BigDecimal bxmPreIncome;

    /**
     * 结算收益
     */
    private BigDecimal statementIncome;

    /**
     * 收益明细
     */
    private String incomeDetailUrl;

    /**
     * 结算明细
     */
    private String statementDetailUrl;

    /**
     * 流转信息
     */
    private String flowInfo;

    /**
     * 1未结算，2已结算，3已开票，4已收款
     */
    private Integer status;

    private String createUser;

    private Date createTime;

    private String modifyUser;

    private Date modifyTime;


    public static final String ID = "id";

    public static final String COMPANY_NAME = "company_name";

    public static final String COMPANY_TYPE = "company_type";

    public static final String BUSINESS = "business";

    public static final String FINANCIAL_TYPE = "financial_type";

    public static final String INVOICE_TYPE = "invoice_type";

    public static final String MONTH = "month";

    public static final String BXM_PRE_INCOME = "bxm_pre_income";

    public static final String STATEMENT_INCOME = "statement_income";

    public static final String INCOME_DETAIL_URL = "income_detail_url";

    public static final String STATEMENT_DETAIL_URL = "statement_detail_url";

    public static final String FLOW_INFO = "flow_info";

    public static final String STATUS = "status";

    public static final String CREATE_USER = "create_user";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_USER = "modify_user";

    public static final String MODIFY_TIME = "modify_time";

}
