package com.bxm.mccms.common.core.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.mccms.common.model.base.BaseEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 审核维护配置
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class ReviewRefuseConfig extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 审核环节：1 财务，2 应用，3 广告位
     */
    private Integer sector;

    /**
     * 拒绝理由
     */
    private String refuseReason;

    /**
     * 操作提示建议
     */
    private String advise;

    /**
     * 前端展示理由
     */
    private String showReason;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private String modifyUser;

    /**
     * 修改时间
     */
    private Date modifyTime;

    /**
     * 是否逻辑删除：1 表示删除，0 表示未删除
     */
    private Integer deleted;


    public static final String ID = "id";

    public static final String SECTOR = "sector";

    public static final String REFUSE_REASON = "refuse_reason";

    public static final String ADVISE = "advise";

    public static final String SHOW_REASON = "show_reason";

    public static final String CREATE_USER = "create_user";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_USER = "modify_user";

    public static final String MODIFY_TIME = "modify_time";

    public static final String DELETED = "deleted";

}
