package com.bxm.mccms.common.core.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.mccms.common.model.base.BaseEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 广告位场景-活动
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-08-13
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SceneActivity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 广告位ID
     */
    private String positionId;

    /**
     * 活动id
     */
    private String activityId;

    /**
     * 活动url
     */
    private String activityUrl;

    /**
     * 自定义参数
     */
    private String diyArgs;

    /**
     * 活动应用类型：1直接投放，2测试活动
     */
    private Integer type;

    /**
     * 有效期开始
     */
    private Date startDate;

    /**
     * 有效期结束
     */
    private Date endDate;

    /**
     * 流量分配占比
     */
    private Integer rateOfFlow;

    /**
     * 广告位配置json格式
     * [
     *     {
     *         "id": 1,
     *         "positionScene": 1,
     *         "informationFlowTemplate": 2,
     *         "positionId": 804434342111
     *     },
     *     {
     *         "id": 2,
     *         "positionScene": 3,
     *         "informationFlowTemplate": null,
     *         "positionId": 804434342754
     *     }
     * ]
     */
    private String positionConfig;

    /**
     * 开关,1:开,0:关
     */
    private Integer opened;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private String modifyUser;

    /**
     * 修改时间
     */
    private Date modifyTime;


    public static final String ID = "id";

    public static final String POSITION_ID = "position_id";

    public static final String ACTIVITY_ID = "activity_id";

    public static final String ACTIVITY_URL = "activity_url";

    public static final String DIY_ARGS = "diy_args";

    public static final String TYPE = "type";

    public static final String START_DATE = "start_date";

    public static final String END_DATE = "end_date";

    public static final String RATE_OF_FLOW = "rate_of_flow";

    public static final String POSITION_CONFIG = "position_config";

    public static final String OPENED = "opened";

    public static final String CREATE_USER = "create_user";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_USER = "modify_user";

    public static final String MODIFY_TIME = "modify_time";

}
