package com.bxm.mccms.common.core.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.mccms.common.model.base.BaseEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 广告位场景-媒体入口素材
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-05-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SceneDspEntranceCreative extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 广告位ID
     */
    private String positionId;

    /**
     * 广告位类型
     */
    private Integer positionType;

    /**
     * 广告位类型的描述：多图文、单图文等
     */
    private String positionTypeDesc;

    /**
     * 素材名称
     */
    private String creativeName;

    /**
     * ICON（广告位约束），单个的。
     */
    private String creativeIcon;

    /**
     * 广告标题（广告位约束），单个的。
     */
    private String creativeTitle;

    /**
     * 广告内容（广告位约束），多个按英文逗号分隔。允许空元素。如：title,title,,title
     */
    private String creativeContent;

    /**
     * 广告图片（广告位约束），多个按英文逗号分隔。允许空元素。如：url,,url
     */
    private String creativePicture;

    /**
     * 广告封面图片（广告位约束），多个按英文逗号分隔。允许空元素。如：url,,url
     */
    private String creativeCover;

    /**
     * 广告视频（广告位约束），多个按英文逗号分隔。允许空元素。如：url,,url
     */
    private String creativeVideo;

    /**
     * 开关,1:开,0:关
     */
    private Integer opened;

    /**
     * 素材来源：1是为手动上传，2为素材库素材
     * @see com.bxm.mccms.facade.enums.SceneDspEntranceCreativeEnum.CreativeSource
     */
    private Integer creativeSource;

    /**
     * 标签：多个用逗号分割
     */
    private String tags;

    /**
     * 素材宽度
     */
    private Integer width;

    /**
     * 素材高度
     */
    private Integer height;

    /**
     * 文件大小
     */
    private Long fileSize;

    /**
     * 文件格式
     */
    private String fileFormat;

    /**
     * md5
     */
    private String md5;

    /**
     * 动画样式
     * @see com.bxm.mccms.facade.enums.SceneDspEntranceCreativeEnum.AnimationStyle
     */
    private Integer animationStyle;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private String modifyUser;

    /**
     * 修改时间
     */
    private Date modifyTime;


    public static final String ID = "id";

    public static final String POSITION_ID = "position_id";

    public static final String POSITION_TYPE = "position_type";

    public static final String POSITION_TYPE_DESC = "position_type_desc";

    public static final String CREATIVE_NAME = "creative_name";

    public static final String CREATIVE_ICON = "creative_icon";

    public static final String CREATIVE_TITLE = "creative_title";

    public static final String CREATIVE_CONTENT = "creative_content";

    public static final String CREATIVE_PICTURE = "creative_picture";

    public static final String CREATIVE_COVER = "creative_cover";

    public static final String CREATIVE_VIDEO = "creative_video";

    public static final String OPENED = "opened";

    public static final String CREATIVE_SOURCE = "creative_source";

    public static final String TAGS = "tags";

    public static final String WIDTH = "width";

    public static final String HEIGHT = "height";

    public static final String FILE_SIZE = "file_size";

    public static final String FILE_FORMAT = "file_format";

    public static final String MD5 = "md5";

    public static final String CREATE_USER = "create_user";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_USER = "modify_user";

    public static final String MODIFY_TIME = "modify_time";

}
