package com.bxm.mccms.common.core.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.mccms.common.model.base.BaseEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 广告位场景设置
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-10-29
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SceneSetting extends BaseEntity {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 广告位ID
     */
    private String positionId;

    /**
     * 场景类型
     */
    private Integer sceneType;

    /**
     * 活动id
     */
    private String activityId;

    /**
     * 活动url
     */
    private String activityUrl;

    /**
     * 激励视频广告位
     */
    private String inspireVideoPositionId;

    /**
     * H5链接
     */
    private String h5Url;

    /**
     * 素材来源：1是为手动上传，2为素材库素材
     */
    private Integer creativeSource;

    /**
     * 广告标题（广告位约束），单个的。
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String creativeTitle;

    /**
     * 广告内容（广告位约束），多个按英文逗号分隔。允许空元素。如：title,title,,title
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String creativeContent;

    /**
     * 筛选类型：1标签筛选，2个性筛选
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer screenType;

    /**
     * 筛选值，多个用逗号分割
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private String screenValue;


    public static final String ID = "id";

    public static final String POSITION_ID = "position_id";

    public static final String SCENE_TYPE = "scene_type";

    public static final String ACTIVITY_ID = "activity_id";

    public static final String ACTIVITY_URL = "activity_url";

    public static final String INSPIRE_VIDEO_POSITION_ID = "inspire_video_position_id";

    public static final String H5_URL = "h5_url";

    public static final String CREATIVE_SOURCE = "creative_source";

    public static final String CREATIVE_TITLE = "creative_title";

    public static final String CREATIVE_CONTENT = "creative_content";

    public static final String SCREEN_TYPE = "screen_type";

    public static final String SCREEN_VALUE = "screen_value";

}
