package com.bxm.mccms.common.core.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.mccms.common.model.base.BaseEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 屏蔽策略
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-01-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class ShieldStrategy extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 策略名称
     */
    private String strategyName;

    /**
     * 屏蔽关键字
     */
    private String shieldKeyword;

    /**
     * 屏蔽安卓包名
     */
    private String androidPackageName;

    /**
     * 屏蔽IOS的ID
     */
    private String iosId;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private String modifyUser;

    /**
     * 修改时间
     */
    private Date modifyTime;


    public static final String ID = "id";

    public static final String STRATEGY_NAME = "strategy_name";

    public static final String SHIELD_KEYWORD = "shield_keyword";

    public static final String ANDROID_PACKAGE_NAME = "android_package_name";

    public static final String IOS_ID = "ios_id";

    public static final String CREATE_USER = "create_user";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_USER = "modify_user";

    public static final String MODIFY_TIME = "modify_time";

}
