package com.bxm.mccms.common.core.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.mccms.common.model.base.BaseEntity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 系统字典
 * </p>
 *
 * @author zhengwangeng
 * @since 2019-12-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class SysDict extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 父级字典值
     */
    private String parentDictValue;

    /**
     * 分类code
     */
    private String typeCode;

    /**
     * 字典名称
     */
    private String dictName;

    /**
     * 字典值
     */
    private String dictValue;

    /**
     * 是否是字典分组，1 是分组，0 不是分组
     */
    private Integer isDictGroup;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人
     */
    private String modifyUser;

    /**
     * 修改时间
     */
    private Date modifyTime;


    public static final String ID = "id";

    public static final String PARENT_DICT_VALUE = "parent_dict_value";

    public static final String TYPE_CODE = "type_code";

    public static final String DICT_NAME = "dict_name";

    public static final String DICT_VALUE = "dict_value";

    public static final String IS_DICT_GROUP = "is_dict_group";

    public static final String CREATE_USER = "create_user";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_USER = "modify_user";

    public static final String MODIFY_TIME = "modify_time";

}
