package com.bxm.mccms.common.core.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.mccms.common.model.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 任务
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-11-18
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class Task extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 任务名称
     */
    private String name;

    /**
     * 有效期开始
     */
    private Date startDate;

    /**
     * 有效期结束
     */
    private Date endDate;

    /**
     * 任务类型。1- 曝光点击任务、2- 静默唤醒任务、3- 复制任务
     */
    private Integer type;

    /**
     * 总曝光限制。0表示不限
     */
    private Long viewTotalLimit;

    /**
     * 日曝光限制。0表示不限
     */
    private Long viewDayLimit;

    /**
     * 总点击限制。0表示不限
     */
    private Long clickTotalLimit;

    /**
     * 日点击限制。0表示不限
     */
    private Long clickDayLimit;

    /**
     * 总唤醒限制。0表示不限
     */
    private Long wakeUpTotalLimit;

    /**
     * 日唤醒限制。0表示不限
     */
    private Long wakeUpDayLimit;

    /**
     * 曝光点击间隔不超过该值，单位为秒
     */
    private Integer viewClickInterval;

    /**
     * 唤醒回到桌面不超过该值，单位为秒
     */
    private Integer wakeUpToDesktop;

    /**
     * 应用包名
     */
    private String packageName;

    /**
     * 跳转协议
     */
    private String jumpProtocol;

    /**
     * 唤醒检查接口。0:无 、1:腾讯新闻
     */
    private Integer wakeCheckApi;

    /**
     * 下发监测地址，多个用逗号分隔
     */
    private String acquireMonitorUrl;

    /**
     * 曝光监测地址，多个用逗号分隔
     */
    private String viewMonitorUrl;

    /**
     * 点击监测地址，多个用逗号分隔
     */
    private String clickMonitorUrl;

    /**
     * 准备就绪监测地址，多个用逗号分隔
     */
    private String readyMonitorUrl;

    /**
     * 唤醒完成监测地址，多个用逗号分隔
     */
    private String wakeUpMonitorUrl;

    /**
     * 唤醒成功监测地址，多个用逗号分隔
     */
    private String wakeSucceedMonitorUrl;

    /**
     * 操作系统。1-安卓，2-IOS
     */
    private Integer os;

    /**
     * 优先级
     */
    private Integer priority;

    /**
     * 状态。1 正常、2 暂停、3 停止、
     */
    private Integer status;

    /**
     * 暂停原因。1-总曝光限制、2-日曝光限制、3-总点击限制、4-日点击限制、5-人工手动暂停、6-总唤醒限制、7-日唤醒限制
     */
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Integer pauseReason;

    /**
     * 创建用户
     */
    private String createUser;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新用户
     */
    private String modifyUser;

    /**
     * 更新时间
     */
    private Date modifyTime;

    /**
     * 口令内容
     */
    private String cmdText;

    /**
     * 口令接口,0- 无
     */
    private Integer cmdApi;

    /**
     * 时间间隔,同一设备同一任务的下发时间间隔，单位为分钟
     */
    private Integer timeInterval;


    public static final String ID = "id";

    public static final String NAME = "name";

    public static final String START_DATE = "start_date";

    public static final String END_DATE = "end_date";

    public static final String TYPE = "type";

    public static final String VIEW_TOTAL_LIMIT = "view_total_limit";

    public static final String VIEW_DAY_LIMIT = "view_day_limit";

    public static final String CLICK_TOTAL_LIMIT = "click_total_limit";

    public static final String CLICK_DAY_LIMIT = "click_day_limit";

    public static final String WAKE_UP_TOTAL_LIMIT = "wake_up_total_limit";

    public static final String WAKE_UP_DAY_LIMIT = "wake_up_day_limit";

    public static final String VIEW_CLICK_INTERVAL = "view_click_interval";

    public static final String WAKE_UP_TO_DESKTOP = "wake_up_to_desktop";

    public static final String PACKAGE_NAME = "package_name";

    public static final String JUMP_PROTOCOL = "jump_protocol";

    public static final String WAKE_CHECK_API = "wake_check_api";

    public static final String ACQUIRE_MONITOR_URL = "acquire_monitor_url";

    public static final String VIEW_MONITOR_URL = "view_monitor_url";

    public static final String CLICK_MONITOR_URL = "click_monitor_url";

    public static final String READY_MONITOR_URL = "ready_monitor_url";

    public static final String WAKE_UP_MONITOR_URL = "wake_up_monitor_url";

    public static final String WAKE_SUCCEED_MONITOR_URL = "wake_succeed_monitor_url";

    public static final String OS = "os";

    public static final String PRIORITY = "priority";

    public static final String STATUS = "status";

    public static final String PAUSE_REASON = "pause_reason";

    public static final String CREATE_USER = "create_user";

    public static final String CREATE_TIME = "create_time";

    public static final String MODIFY_USER = "modify_user";

    public static final String MODIFY_TIME = "modify_time";

    public static final String CMD_TEXT = "cmd_text";

    public static final String CMD_API = "cmd_api";

    public static final String TIME_INTERVAL = "time_interval";

}
