package com.bxm.mccms.common.core.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.bxm.mccms.common.model.base.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 任务规则配置
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-03-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class TaskRules extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 任务ID
     */
    private Long taskId;

    /**
     * 规则类型。1- 地域限制规则、2- 广告位黑白名单规则、3- 频次限制规则
     */
    private Integer ruleType;

    /**
     * 规则值，规则类型不同值的数据结构也不同
     */
    private String ruleValue;


    public static final String ID = "id";

    public static final String TASK_ID = "task_id";

    public static final String RULE_TYPE = "rule_type";

    public static final String RULE_VALUE = "rule_value";

}
