package com.bxm.mccms.common.core.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.mccms.common.core.entity.PositionIncome;
import com.bxm.mccms.common.model.income.PositionIncomeDTO;
import com.bxm.mccms.common.model.income.PositionIncomeQueryDTO;

/**
 * <h3>广告位收益</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/1/9 16:50
 */
public interface PositionIncomeMapper extends BaseMapper<PositionIncome> {

    int updateStatusByPositionId(@Param("positionId") String positionId,
                                 @Param("afterStatus") int afterStatus,
                                 @Param("modifyUser") String modifyUser,
                                 @Param("datetime") String datetime);

    int updateStatusByDatetime(@Param("afterStatus") int afterStatus,
                                 @Param("modifyUser") String modifyUser,
                                 @Param("datetime") String datetime);

    List<PositionIncome> findByDeveloperIdList(@Param("condition") PositionIncomeDTO condition);


    Page<PositionIncome> findPage(IPage page, @Param("condition") PositionIncomeQueryDTO condition);

}
