package com.bxm.mccms.common.core.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.bxm.datapark.web.model.SspActivity;
import com.bxm.mccms.common.core.entity.SceneActivity;
import com.bxm.mccms.common.model.position.SceneActivityVO;

/**
 * <p>
 * 广告位场景-活动 Mapper 接口
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-08-13
 */
public interface SceneActivityMapper extends BaseMapper<SceneActivity> {

    int updateUrl(@Param("activityId") String activityId,
                  @Param("oldActivityUrl") String oldActivityUrl,
                  @Param("newActivityUrl") String newActivityUrl);

    /**
     * 查询可用的活动列表数据
     * @param search
     * @return
     */
    List<SspActivity> findActivity(@Param("search") SspActivity search);

    /**
     * 更加广告位查询配置的活动
     * @param positionId
     * @return
     */
    List<SceneActivityVO> list(@Param("positionId") String positionId);
}
