package com.bxm.mccms.common.core.mapper;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.mccms.common.core.entity.SceneSetting;
import com.bxm.mccms.common.model.position.SceneSettingQueryDTO;
import com.bxm.mccms.common.model.position.SceneSettingListVO;

/**
 * <p>
 * 广告位场景设置 Mapper 接口
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-05-28
 */
public interface SceneSettingMapper extends BaseMapper<SceneSetting> {

    Page<SceneSettingListVO> pageBySearch(Page page, @Param("dto") SceneSettingQueryDTO dto);

    /**
     * 查找个性筛选中包含指定素材ID的数据
     * @param screenType=2
     * @param creativeId
     * @return
     */
    List<SceneSetting> getContainsIdSceneSettingConfig(@Param("screenType") Integer screenType, @Param("creativeId") Long creativeId);
}
