package com.bxm.mccms.common.core.service;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;

/**
 * 基础服务类
 *
 * <p>
 * Date 2019/1/18 14:11
 */
public interface BaseService<T> extends IService<T> {

    /**
     * 根据主键ID 查询 实体， 无结果抛异常
     *
     * @param id 主键ID
     * @return
     */
    T findByIdWithNotNull(Serializable id);

    /**
     * 单列 通用查询方法     * @return
     *
     * @param columnName 列名
     * @param value      值
     * @return
     */
    T findOneByOneParam(String columnName, Object value);


    /**
     * 单列 通用查询方法
     *
     * @param columnName 列名
     * @param value      值
     * @return
     */
    List<T> findListByOneParam(String columnName, Object value);

    /**
     * 单列 通用查询方法 ， 无结果抛异常
     *
     * @param columnName 列名
     * @param value      值
     * @return
     */
    T findOneByOneParamWithNotNull(String columnName, Object value);

    /**
     * 分页查询@return
     *
     * @param wrapper  查询条件
     * @param current  页码
     * @param size 页面大小
     * @return
     */
    IPage<T> findPage(QueryWrapper<T> wrapper, Integer current, Integer size);

    List<T> selectBatchIds(Collection<? extends Serializable> idList);

}
