package com.bxm.mccms.common.core.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.mccms.common.core.entity.DeveloperBill;
import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.mccms.common.model.income.DeveloperBillDTO;
import com.bxm.mccms.common.model.income.DeveloperBillVO;
import com.bxm.mccms.common.model.income.DeveloperWithdrawlVO;

import java.math.BigDecimal;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/1/9 16:50
 */
public interface IDeveloperBillService extends IService<DeveloperBill> {

    boolean init();

    Boolean publish(Long id, String month);

    Boolean deduction(String remark, BigDecimal money, Long id);

    IPage<DeveloperBillVO> findAll(DeveloperBillDTO query);

    IPage<DeveloperWithdrawlVO> findWithdrawalAll(DeveloperBillDTO query);
}
