package com.bxm.mccms.common.core.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.mccms.common.core.entity.DspCreative;
import com.bxm.mccms.common.model.dsp.DspCreativeDTO;
import com.bxm.mccms.facade.model.adx.CreativeFacadeVO;
import com.bxm.mccms.facade.model.adx.CreativeReviewFacadeVO;

/**
 * <p>
 * 创意审核 服务类
 * </p>
 *
 * @author Allen Hu
 * @since 2019-12-18
 */
public interface IDspCreativeService extends IService<DspCreative> {

    /**
     * 分页查询<br/>
     *
     * @param page
     * @param query
     * @return
     */
    Page<DspCreative> pageByAudit(Page page, DspCreativeDTO query);
    
    /**
     * 批次插入新素材
     * @param dspCreatives
     * @return
     */
    List<String> batchSave(List<DspCreative> dspCreatives);

    /**
     * 批次修改素材
     * @param dspCreatives
     * @return
     */
    List<String> batchUpdate(List<DspCreative> dspCreatives);

    /**
     * 按ID查询素材详情
     * @param dspCrtIds
     * @param dspId
     * @return
     */
    List<CreativeFacadeVO> queryCreativeByIds(List<String> dspCrtIds, Long dspId);

    /**
     * 按ID查询素材审核状态
     * @param dspCrtIds
     * @param dspId
     * @return
     */
    List<CreativeReviewFacadeVO> queryReviewStatus(List<String> dspCrtIds, Long dspId);

    /**
     * 审核状态<br/>
     *
     * @param body
     * @return
     */
    @Transactional(rollbackFor = {Exception.class})
    Boolean updateAuditStatus(DspCreative body);
}
