package com.bxm.mccms.common.core.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.mccms.common.core.entity.Dsp;
import com.bxm.mcssp.common.entity.IDAndNameVO;

/**
 * <p>
 * 广告平台 服务类
 * </p>
 *
 * @author Allen Hu
 * @since 2019-12-18
 */
public interface IDspService extends IService<Dsp> {

    /**
     * 分页查询<br/>
     *
     * @param page
     * @param query
     * @return
     */
    IPage<Dsp> pageByLike(Page page, Dsp query);

    /**
     * ID和名称数据<br/>
     *
     * @param keyword
     * @return
     */
    List<IDAndNameVO> list(String keyword);

    /**
     * 唯一性查询<br/>
     *
     * @param dspCode
     * @return
     */
    Dsp getByOnly(String dspCode);

    /**
     * 新增<br/>
     *
     * @param t
     * @return
     */
    @Transactional(rollbackFor = {Exception.class})
    Boolean saveInfo(Dsp t);

    /**
     * 修改<br/>
     *
     * @param t
     * @return
     */
    @Transactional(rollbackFor = {Exception.class})
    Boolean updateInfo(Dsp t);
    
    /**
     * 启用禁用<br/>
     *
     * @param id
     * @param deleted
     * @return
     */
    @Transactional(rollbackFor = {Exception.class})
    Boolean updateDeleted(Long id, Integer deleted);
}
