package com.bxm.mccms.common.core.service;

import org.springframework.web.multipart.MultipartFile;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.core.entity.PositionChannelIncome;
import com.bxm.mccms.common.model.income.PositionChannelIncomeListVO;
import com.bxm.mccms.common.model.income.PositionChannelIncomeQueryDTO;
import com.bxm.mccms.common.model.income.PositionChannelIncomeSyncDTO;
import com.bxm.mccms.common.model.income.PositionChannelIncomeUploadVO;

/**
 * <p>
 * 广告位渠道收益记录 服务类
 * </p>
 *
 * @author zhengwangeng
 * @since 2021-01-15
 */
public interface IPositionChannelIncomeService extends BaseService<PositionChannelIncome> {

    Page<PositionChannelIncomeListVO> pageBySearch(Page page, PositionChannelIncomeQueryDTO dto);

    PositionChannelIncomeUploadVO upload(UserVo userVo, MultipartFile file);

    Boolean syncChannelData(UserVo userVo, PositionChannelIncomeSyncDTO positionChannelIncomeSyncDTO);
}
