package com.bxm.mccms.common.core.service;

import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.mccms.common.core.entity.PositionDspCreative;
import com.bxm.mccms.common.model.dsp.PositionDspCreativeDTO;
import com.bxm.mccms.common.model.dsp.PositionDspCreativeVO;

/**
 * <p>
 * 广告位创意审核 服务类
 * </p>
 *
 * @author Allen Hu
 * @since 2019-12-18
 */
public interface IPositionDspCreativeService extends IService<PositionDspCreative> {
    
    /**
     * 分页查询<br/>
     *
     * @param page
     * @param query
     * @return
     */
    Page<PositionDspCreativeVO> pageByAudit(Page page, PositionDspCreativeDTO query);

    /**
     * 审核状态<br/>
     *
     * @param body
     * @return
     */
    @Transactional(rollbackFor = {Exception.class})
    Boolean updateAuditStatus(PositionDspCreative body);
}
