package com.bxm.mccms.common.core.service;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.bxm.mccms.common.core.entity.PositionDspPos;
import com.bxm.mccms.common.helper.enums.DspStaticEnum;
import com.bxm.mccms.common.model.position.PositionDspPosAnalyzeVO;
import com.bxm.mccms.common.model.position.PositionDspPosDTO;
import com.bxm.mccms.common.model.position.PositionDspPosVO;

/**
 * <p>
 * 广告位流量分配 服务类
 * </p>
 *
 * @author Allen Hu
 * @since 2019-12-18
 */
public interface IPositionDspPosService extends IService<PositionDspPos> {

    /**
     * 分页查询<br/>
     *
     * @param page
     * @param query
     * @return
     */
    Page<PositionDspPosAnalyzeVO> pageByAnalyze(Page page, PositionDspPosDTO query);
    
    /**
     * 获取流量分配信息
     */
    PositionDspPosVO getDetail(Long id);

    /**
     * 唯一性查询<br/>
     *
     * @param positionId 广告位ID
     * @param dspId DSP ID
     * @return
     */
    PositionDspPos getByOnly(String positionId, Long dspId);

    /**
     * 新增<br/>
     *
     * @param t
     * @return
     */
    @Transactional(rollbackFor = {Exception.class})
    Boolean saveInfo(PositionDspPos t);

    /**
     * 修改<br/>
     *
     * @param t
     * @return
     */
    @Transactional(rollbackFor = {Exception.class})
    Boolean updateInfo(PositionDspPos t);
    
    /**
     * 流量开关<br/>
     *
     * @param id
     * @param opened
     * @return
     */
    @Transactional(rollbackFor = {Exception.class})
    Boolean updateOpened(Long id, Integer opened);


    /**
     * 根据dspid 查询对应的广告位
     * @param dspIds
     * @return
     */
    List<PositionDspPos> getByDspId(List<Long> dspIds);

    /**
     * 添加特殊的DSP
     * @param positionId
     * @param dspStaticEnum
     * @param dspPosid
     * @return
     */
    Boolean addDsp(String positionId, DspStaticEnum dspStaticEnum, String dspPosid);

}
