package com.bxm.mccms.common.core.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.model.income.PositionChannelIncomeSyncDTO;
import com.bxm.mccms.common.model.income.PositionIncomeDTO;
import com.bxm.mccms.common.model.income.PositionIncomeQueryDTO;
import com.bxm.mccms.common.model.income.PositionIncomeVO;
import com.bxm.mccms.common.model.income.datagrab.AuthenticationInfoCacheVO;

/**
 * <h3>类的基本描述</h3>
 *
 * @author hcmony
 * @since V1.0.0, 2020/1/9 16:50
 */
public interface IPositionIncomeService {

    int init();

    IPage<PositionIncomeVO> findAll(UserVo user, PositionIncomeQueryDTO positionIncomeDTO);

    Boolean update(PositionIncomeDTO positionIncomeDTO);

    Boolean publish(PositionIncomeDTO positionIncomeDTO);

    /**
     * 同步数据抓取的数据
     * @return
     */
    Boolean syncDatagrabArgs(AuthenticationInfoCacheVO authenticationInfoCacheVO);

    /**
     * 同步穿山甲平台数据
     * @return
     */
    Boolean syncOceanengineData(String date);

    /**
     * 同步广点通平台数据
     * @return
     */
    Boolean syncAdnetData(String date);


    /**
     * 广点通收益数据同步到广告位渠道收益记录表
     * @param datetime
     * @param positionChannelIncomeSyncDTO
     * @return
     */
    Boolean syncAdnetIncomeDataToPositionChannelIncome(String datetime, PositionChannelIncomeSyncDTO positionChannelIncomeSyncDTO);

    /**
     * 互动收益数据同步到广告位收益表
     * @return
     */
    Boolean syncAdsData(String datetime);

    /**
     * 互动收益数据同步到广告位渠道收益记录表
     * @param datetime
     * @param positionChannelIncomeSyncDTO
     * @return
     */
    Boolean syncAdsDataToPositionChannelIncome(String datetime, PositionChannelIncomeSyncDTO positionChannelIncomeSyncDTO);

}
