package com.bxm.mccms.common.core.service;

import org.springframework.web.multipart.MultipartFile;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.core.entity.Receipt;
import com.bxm.mccms.common.model.income.ReceiptQueryDTO;

/**
 * <p>
 * 收款 服务类
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-07-29
 */
public interface IReceiptService extends BaseService<Receipt> {

    Page<Receipt> pageBySearch(Page page, ReceiptQueryDTO dto);

    boolean upload(UserVo userVo, MultipartFile file);

    boolean delete(UserVo userVo, Long id);

    boolean updateDetailUrl(UserVo userVo, Receipt dto);

    boolean updateStatementIncome(UserVo userVo, Receipt dto);

    boolean updateStatus(UserVo userVo, Receipt dto);
}
