package com.bxm.mccms.common.core.service;

import java.util.List;

import com.bxm.datapark.web.model.SspActivity;
import com.bxm.mccms.common.core.entity.SceneActivity;
import com.bxm.mccms.common.model.position.SceneActivityVO;
import com.bxm.mccms.facade.enums.SceneDspEnum;
import com.bxm.mccms.facade.model.activity.ActivityFacadeDTO;

/**
 * <p>
 * 广告位场景-活动 服务类
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-08-13
 */
public interface ISceneActivityService extends BaseService<SceneActivity> {

    /**
     * 获取可用的活动列表
     * @return
     */
    List<SspActivity> getAllActivityList(SceneDspEnum.SceneType sceneType);

    /**
     * 获取活动列表
     * @param positionId
     * @param date
     * @return
     */
    List<SceneActivityVO> getList(String positionId, String date);

    /**
     * 同步活动URL
     * @param dto
     * @return 修改的行数
     */
    Integer syncUrl(ActivityFacadeDTO dto);

}
