package com.bxm.mccms.common.core.service;

import java.util.List;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.acl.facade.model.UserVo;
import com.bxm.mccms.common.core.entity.SceneDspEntranceCreative;
import com.bxm.mccms.common.model.position.CreativeDTO;
import com.bxm.mccms.common.model.position.CreativeListVO;
import com.bxm.mccms.common.model.position.SceneDspEntranceCreativeQueryDTO;
import com.bxm.mccms.common.model.position.SceneDspEntranceCreativeVO;

/**
 * <p>
 * 广告位场景-媒体入口素材服务类
 * </p>
 *
 * @author zhengwangeng
 * @since 2020-05-28
 */
public interface ISceneDspEntranceCreativeService extends BaseService<SceneDspEntranceCreative> {

    /**
     * 分页查询
     * @param user
     * @param page
     * @param dto
     * @return
     */
    Page<CreativeListVO> pageBySearch(UserVo user, Page page, SceneDspEntranceCreativeQueryDTO dto);

    /**
     * 检查数据库中素材和标签是否和redis中一致
     * @return
     */
    String checkCreativeDbEqualCache();

    /**
     * 修改，只能修改状态和标签
     * @param userVo
     * @param creative
     * @return
     */
    Boolean update(UserVo userVo, SceneDspEntranceCreative creative);

    /**
     * 新增
     * @param userVo
     * @param creativeDTO
     * @return
     */
    Boolean add(UserVo userVo, CreativeDTO creativeDTO);


    /*****************************下面部分为广告位场景DSP素材配置相关*****************************/

    /**
     * 获取广告位场景DSP配置的素材列表（手动上传的，素材库-个性筛选的）
     * @param positionId
     * @param date
     * @return
     */
    List<SceneDspEntranceCreativeVO> getList(String positionId, String date);

    /**
     * 根据广告位尺寸得到合适的可出素材数量
     * @param user
     * @param positionId
     * @param tags
     * @return
     */
    Integer getShortlistCreativeCount(UserVo user, String positionId, List<String> tags);
}
